/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class TypeConversionConverter
implements Converter {
    protected DatabaseMapping mapping;
    protected Class dataClass;
    protected String dataClassName;
    protected Class objectClass;
    protected String objectClassName;

    public TypeConversionConverter() {
    }

    public TypeConversionConverter(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class dataClass = null;
        Class objectClass = null;
        try {
            if (this.dataClassName != null) {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        dataClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.dataClassName, true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.dataClassName, exception.getException());
                    }
                } else {
                    dataClass = PrivilegedAccessHelper.getClassForName(this.dataClassName, true, classLoader);
                }
                this.setDataClass(dataClass);
            }
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.dataClassName, exc);
        }
        try {
            if (this.objectClassName != null) {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        objectClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.objectClassName, true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.objectClassName, exception.getException());
                    }
                } else {
                    objectClass = PrivilegedAccessHelper.getClassForName(this.objectClassName, true, classLoader);
                }
                this.setObjectClass(objectClass);
            }
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.objectClassName, exc);
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        Object attributeValue = fieldValue;
        if (attributeValue != null) {
            try {
                attributeValue = ((AbstractSession)session).getDatasourcePlatform().convertObject(attributeValue, this.getDataClass());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
            }
            try {
                attributeValue = ((AbstractSession)session).getDatasourcePlatform().convertObject(attributeValue, this.getObjectClass());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
            }
        }
        return attributeValue;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        if (this.objectClassName == null && this.objectClass != null) {
            this.objectClassName = this.objectClass.getName();
        }
        return this.objectClassName;
    }

    public Class getDataClass() {
        return this.dataClass;
    }

    public String getDataClassName() {
        if (this.dataClassName == null && this.dataClass != null) {
            this.dataClassName = this.dataClass.getName();
        }
        return this.dataClassName;
    }

    public void setDataClass(Class dataClass) {
        this.dataClass = dataClass;
    }

    public void setDataClassName(String dataClassName) {
        this.dataClassName = dataClassName;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    @Override
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        try {
            return ((AbstractSession)session).getDatasourcePlatform().convertObject(attributeValue, this.getDataClass());
        }
        catch (ConversionException e) {
            throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
        }
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        this.mapping = mapping;
        if (this.getMapping().isDirectToFieldMapping()) {
            AbstractDirectMapping directMapping = (AbstractDirectMapping)this.getMapping();
            if (directMapping.getFieldClassification() == null) {
                directMapping.setFieldClassification(this.getDataClass());
            }
            if (this.getObjectClass() == null) {
                this.setObjectClass(directMapping.getAttributeClassification());
            }
        } else if (this.getMapping().isDirectCollectionMapping()) {
            ((DirectCollectionMapping)this.getMapping()).setAttributeClassification(this.getObjectClass());
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

