/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql;

import com.sap.dbtech.jdbcext.DataSourceSapDB;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SDBsql {
    private String dbUser;
    private String password;
    private String dbName;
    private String dbServer;
    private DataSourceSapDB ds;
    private DataSourceSapDB dataSource;
    private Connection sqlConnection;
    private boolean lastConnectionOK = false;
    private String RootPages;
    private String FileIds;
    private static final String HEXES = "0123456789ABCDEF";

    public String getRootPages() {
        return this.RootPages;
    }

    public void setRootPages(String RootPages) {
        this.RootPages = RootPages;
    }

    public String getFileIds() {
        return this.FileIds;
    }

    public void setFileIds(String FileIds) {
        this.FileIds = FileIds;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbServer() {
        return this.dbServer;
    }

    public void setDbServer(String dbServer) {
        this.dbServer = dbServer;
    }

    public DataSourceSapDB getDs() {
        return this.ds;
    }

    public void setDs(DataSourceSapDB ds) {
        this.ds = ds;
    }

    public void createDBConnection(String dbserver, String dbname, String dbuser, String dbpwd) {
        try {
            DataSourceSapDB dats = new DataSourceSapDB();
            dats = new DataSourceSapDB();
            dats.setServerName(dbserver);
            dats.setDatabaseName(dbname);
            dats.setUser(dbuser);
            dats.setPassword(dbpwd);
            this.sqlConnection = dats.getConnection();
            this.lastConnectionOK = true;
        }
        catch (Exception e) {
            this.lastConnectionOK = false;
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public boolean isLastConnectionOK() {
        return this.lastConnectionOK;
    }

    public void closeDBConnection() {
        try {
            if (this.isLastConnectionOK()) {
                this.sqlConnection.close();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public ResultSet execSQL(String statement) {
        ResultSet rs = null;
        try {
            Statement s = this.sqlConnection.createStatement();
            rs = s.executeQuery(statement);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return rs;
    }

    public ResultSet execCheckRootsOnly(String rootpages) {
        ResultSet rs = null;
        try {
            Statement s = this.sqlConnection.createStatement();
            rs = s.executeQuery("SELECT * FROM ROOTS WHERE ROOT IN(" + rootpages + ")");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return rs;
    }

    public ResultSet execCheckTables(String rootpages, String fileids) {
        ResultSet rs = null;
        try {
            Statement s = this.sqlConnection.createStatement();
            rs = s.executeQuery("SELECT F.ROOT, F.FILEID, F.PRIMARYFILEID, F.TYPE, T.* FROM FILES F, TABLES T WHERE (T.TABLEID = F.FILEID OR T.TABLEID = F.PRIMARYFILEID) AND (F.ROOT IN (" + rootpages + ") " + "OR " + "F.FILEID IN " + "(" + fileids + ")) " + "AND F.TYPE <> 'INDEX' ");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return rs;
    }

    public ResultSet execCheckIndexes(String rootpages, String fileids) {
        ResultSet rs = null;
        try {
            Statement s = this.sqlConnection.createStatement();
            rs = s.executeQuery("SELECT     F.ROOT, F.FILEID, I.* FROM     FILES F, INDEXES I WHERE     (I.FILEID = F.FILEID)     AND     (F.ROOT IN         (" + rootpages + ") " + "     OR " + "      F.FILEID IN " + "         (" + fileids + ")) ");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return rs;
    }

    public ResultSet execCheckClassContainers(String rootpages, String fileids) {
        ResultSet rs = null;
        try {
            Statement s = this.sqlConnection.createStatement();
            rs = s.executeQuery("SELECT     F.ROOT, F.FILEID,F.PRIMARYFILEID, F.TYPE, C.* FROM     FILES F, CLASSCONTAINERS C WHERE     (C.CLASS_ID = F.FILEID OR C.CLASS_ID = F.PRIMARYFILEID)     AND     (F.ROOT IN         (" + rootpages + ") " + "     OR " + "      F.FILEID IN " + "         (" + fileids + ")) ");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return rs;
    }

    public String getDBVersion(int versionToGet) {
        String dbVersion = "";
        try {
            Statement s = this.sqlConnection.createStatement();
            ResultSet rs = s.executeQuery("SELECT * FROM \"DOMAIN\".\"VERSIONS\"");
            rs.next();
            if (versionToGet == 1) {
                dbVersion = rs.getString(1).substring(10, 13);
            } else if (versionToGet == 2) {
                dbVersion = rs.getString(1).substring(10, 16);
            } else if (versionToGet == 3) {
                dbVersion = rs.getString(1).substring(10, 28);
            } else if (versionToGet == 4) {
                dbVersion = rs.getString(1).substring(10, 40);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return dbVersion;
    }

    public void fillResultTable(JTable resultGrid, ResultSet rs, int dbversion) {
        try {
            resultGrid.setModel(SDBsql.buildTableModel(rs, dbversion));
            this.resizeColumnWidth(resultGrid);
            resultGrid.setAutoResizeMode(0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public static DefaultTableModel buildTableModel(ResultSet rs, int dbversion) throws SQLException, UnsupportedEncodingException {
        ResultSetMetaData metaData = rs.getMetaData();
        Vector<String> columnNames = new Vector<String>();
        int columnCount = metaData.getColumnCount();
        for (int column = 1; column <= columnCount; ++column) {
            columnNames.add(metaData.getColumnName(column));
        }
        Vector data = new Vector();
        while (rs.next()) {
            Vector<Object> vector = new Vector<Object>();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                if (metaData.getColumnName(columnIndex).equalsIgnoreCase("FILEID") || metaData.getColumnName(columnIndex).equalsIgnoreCase("TABLEID") || metaData.getColumnName(columnIndex).equalsIgnoreCase("PRIMARYFILEID") || metaData.getColumnName(columnIndex).equalsIgnoreCase("GUID") || metaData.getColumnName(columnIndex).equalsIgnoreCase("CLASS_ID") || metaData.getColumnName(columnIndex).equalsIgnoreCase("FILE_ID")) {
                    if (rs.getString(columnIndex) != null) {
                        vector.add(SDBsql.convertToHex(rs.getBytes(columnIndex)));
                        continue;
                    }
                    vector.add("");
                    continue;
                }
                vector.add(rs.getObject(columnIndex));
            }
            data.add(vector);
        }
        return new DefaultTableModel(data, columnNames);
    }

    static String convertToHex(byte[] byteArray) {
        StringBuilder hex = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            int width = 100;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component comp = table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width, width);
            }
            columnModel.getColumn(column).setPreferredWidth(width);
        }
    }
}

