/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.cache;

import com.sap.dbtech.util.cache.DListElement;
import java.util.Dictionary;
import java.util.Hashtable;

public class LruCache {
    private Dictionary lookup;
    private Association lruTop;
    private Association lruBottom;
    private int currentSize;
    private int maxSize;
    static Object[] templateForClear = new Object[0];

    public LruCache(int cacheSize) {
        this.maxSize = cacheSize;
        this.clear();
    }

    public void clear() {
        this.currentSize = 0;
        this.lookup = new Hashtable(this.maxSize);
        this.lruTop = null;
        this.lruBottom = null;
    }

    public Object get(Object key) {
        Object result = null;
        Association entry = (Association)this.lookup.get(key);
        if (entry != null) {
            result = entry.getObject();
            this.moveToTop(entry);
        }
        return result;
    }

    public void put(Object key, Object value) {
        Association newEntry = new Association(key, value);
        this.lookup.put(key, newEntry);
        if (this.lruTop != null) {
            this.lruTop.prepend(newEntry);
        }
        this.lruTop = newEntry;
        if (this.lruBottom == null) {
            this.lruBottom = newEntry;
        }
        ++this.currentSize;
        if (this.currentSize > this.maxSize) {
            this.removeLast();
        }
    }

    private void moveToTop(Association entry) {
        if (entry == this.lruTop) {
            return;
        }
        if (entry == this.lruBottom) {
            this.lruBottom = (Association)entry.previous();
        }
        entry.remove();
        this.lruTop.prepend(entry);
        this.lruTop = entry;
    }

    private void removeLast() {
        Association toDelete = this.lruBottom;
        this.lruBottom = (Association)toDelete.previous();
        this.lookup.remove(toDelete.getKey());
        this.removeHook(toDelete);
        --this.currentSize;
    }

    protected void removeHook(Object value) {
    }

    public Object[] clearAll() {
        Object[] result = ((Hashtable)this.lookup).values().toArray(templateForClear);
        this.clear();
        return result;
    }

    private static class Association
    extends DListElement {
        Object key;

        Association(Object key, Object value) {
            super(value);
            this.key = key;
        }

        final Object getKey() {
            return this.key;
        }
    }
}

