/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractGetval;
import com.sap.dbtech.jdbc.translators.GetvalUnicode;
import com.sap.dbtech.jdbc.translators.GetvalUnicodeClob;
import com.sap.dbtech.jdbc.translators.PutvalBlobCopy;
import com.sap.dbtech.jdbc.translators.PutvalUnicode;
import com.sap.dbtech.jdbc.translators.ReaderInputStream;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StreamTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

public class UnicodeStreamTranslator
extends StreamTranslator {
    protected UnicodeStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
        this.characterDatatypePostfix = " UNICODE";
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        Reader reader = this.getCharacterStream(controller, mem, longData);
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream(reader, false);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        String result = this.getString(controller, mem);
        return result;
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        Reader result = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            GetvalUnicode getval = DriverSapDB.isJDBC20 ? new GetvalUnicodeClob(controller.getConnectionSapDB(), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode()) : new GetvalUnicode(controller.getConnectionSapDB(), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode());
            result = ((AbstractGetval)getval).getCharacterStream();
        }
        return result;
    }

    public Clob getClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        GetvalUnicodeClob result = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            result = new GetvalUnicodeClob(controller.getConnectionSapDB(), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode());
        }
        return result;
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        if (stream == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream);
        return this.transCharacterStreamForInput(reader, length);
    }

    public Object transCharacterStreamForInput(Reader reader, long length) throws SQLException {
        if (reader == null) {
            return null;
        }
        return new PutvalUnicode(reader, length, this.bufpos_input);
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        return new PutvalUnicode(val.toCharArray(), this.bufpos_input);
    }

    boolean isPackectEncodingUnicode() {
        return true;
    }

    public Object transClobForInput(Clob clob, ConnectionSapDB conn) throws SQLException {
        AbstractGetval getVal;
        ConnectionSapDB blobConn;
        if (clob == null) {
            return null;
        }
        if (conn.isKernelFeaturesupported(11) && clob instanceof AbstractGetval && (blobConn = (getVal = (AbstractGetval)((Object)clob)).getConnection()).equals(conn) && this.isUnicodeColumn() == getVal.isUnicodeColumn()) {
            return new PutvalBlobCopy(getVal.getDescriptor(), -1, this.bufpos_input);
        }
        return new PutvalUnicode(clob.getCharacterStream(), -1L, this.bufpos_input);
    }
}

