/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.util.cache.LruCache;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;

public class ParseinfoCache
extends LruCache {
    static final int defaultSizeC = 1000;
    private static final int maxFunctionCodeC = 10;
    private boolean keepStats;
    private boolean[] kindFilter;
    private Info[] stats;

    public ParseinfoCache(Properties info) {
        super(ParseinfoCache.getSizeProperty(info));
        this.setOptions(info);
    }

    static int getSizeProperty(Properties info) {
        int result = DriverSapDB.getIntProperty(info, "cachesize", 1000);
        return result;
    }

    private void setOptions(Properties info) {
        String kindDecl = info.getProperty("cache");
        this.kindFilter = new boolean[10];
        if (kindDecl.indexOf(63) >= 0) {
            this.initStats();
        }
        if (kindDecl.indexOf("all") >= 0) {
            for (int i = 0; i < 10; ++i) {
                this.kindFilter[i] = true;
            }
        } else {
            if (kindDecl.indexOf("i") >= 0) {
                this.kindFilter[3] = true;
            }
            if (kindDecl.indexOf("u") >= 0) {
                this.kindFilter[5] = true;
            }
            if (kindDecl.indexOf("d") >= 0) {
                this.kindFilter[9] = true;
            }
            if (kindDecl.indexOf("s") >= 0) {
                this.kindFilter[4] = true;
            }
        }
    }

    private void initStats() {
        this.keepStats = true;
        this.stats = new Info[10];
        this.stats[0] = new Info("other");
        this.stats[3] = new Info("Insert");
        this.stats[4] = new Info("select");
        this.stats[5] = new Info("update");
        this.stats[9] = new Info("delete");
    }

    public Parseinfo findParseinfo(String sqlCmd) {
        Parseinfo result = null;
        result = (Parseinfo)this.get(sqlCmd);
        if (this.keepStats && result != null) {
            this.stats[ParseinfoCache.mapFunctionCode(result.functionCode)].addHit();
        }
        return result;
    }

    public void addParseinfo(Parseinfo parseinfo) {
        int functionCode = ParseinfoCache.mapFunctionCode(parseinfo.functionCode);
        if (this.kindFilter[functionCode]) {
            this.put(parseinfo.sqlCmd, parseinfo);
            parseinfo.cached = true;
            if (this.keepStats) {
                this.stats[functionCode].addMiss();
            }
        }
    }

    private static int mapFunctionCode(int functionCode) {
        switch (functionCode) {
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            default: {
                functionCode = 0;
            }
        }
        return functionCode;
    }

    public Info[] getStats() {
        Info[] result;
        if (!this.keepStats) {
            return null;
        }
        result = new Info[]{this.stats[0], this.stats[3], this.stats[5], this.stats[9], this.stats[4], Info.cummulate(result)};
        return result;
    }

    public void dumpStats(PrintWriter stream) {
        if (!this.keepStats) {
            return;
        }
        stream.println("Parseinfo cache statistics:");
        Info[] allStats = this.getStats();
        for (int i = 0; i < allStats.length; ++i) {
            stream.println(allStats[i].toString());
        }
    }

    public void dumpStats(PrintStream stream) {
        if (!this.keepStats) {
            return;
        }
        stream.println("Parseinfo cache statistics:");
        Info[] stats = this.getStats();
        for (int i = 0; i < stats.length; ++i) {
            stream.println(stats[i].toString());
        }
    }

    public static class Info {
        private String name;
        private long hits;
        private long misses;

        Info(String name) {
            this.name = name;
            this.hits = 0L;
            this.misses = 0L;
        }

        public String toString() {
            return this.name + ": " + this.hits + " hits, " + this.misses + " misses, " + this.hitrate() + "%";
        }

        final void addHit() {
            ++this.hits;
        }

        final void addMiss() {
            ++this.misses;
        }

        public double hitrate() {
            long all = this.hits + this.misses;
            return (double)this.hits / (double)all * 100.0;
        }

        protected static Info cummulate(Info[] stats) {
            Info result = new Info("all");
            for (int i = 0; i < stats.length; ++i) {
                if (stats[i] == null) continue;
                result.hits += stats[i].hits;
                result.misses += stats[i].misses;
            }
            return result;
        }
    }
}

