/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.CallableStatementSapDB;
import com.sap.dbtech.jdbc.CallableStatementSapDBFinalize;
import com.sap.dbtech.jdbc.ClientInfo;
import com.sap.dbtech.jdbc.DatabaseMetaDataMaxDB;
import com.sap.dbtech.jdbc.DatabaseMetaDataSapDB;
import com.sap.dbtech.jdbc.DbsCache;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.InternalStatementSapDB;
import com.sap.dbtech.jdbc.NameHandling;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.jdbc.SavepointSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.StatementSapDBFinalize;
import com.sap.dbtech.jdbc.WrapperDummy;
import com.sap.dbtech.jdbc.exceptions.ConnectionException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.UnicodeConversionException;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.ReplyPacketFactory;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.packet.RequestPacketUnicode;
import com.sap.dbtech.jdbc.trace.TraceControl;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.CountingSemaphore;
import com.sap.dbtech.util.GarbageCursor;
import com.sap.dbtech.util.GarbageParseid;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.UniqueID;
import com.sap.dbtech.util.VersionInfo;
import com.sap.dbtech.util.security.AuthenticationManager;
import com.sap.dbtech.util.security.AuthenticationManagerInterface;
import com.sap.dbtech.util.security.NativeAuthenticationManager;
import com.sap.dbtech.vsp001.DateTimeFormat;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class ConnectionSapDB
extends WrapperDummy
implements Connection {
    public static final int GC_ALLOWED = 1;
    public static final int GC_DELAYED = 2;
    public static final int GC_NONE = 3;
    protected CountingSemaphore m_communicationSemaphore = new CountingSemaphore();
    JdbcCommunication session;
    boolean autocommit = true;
    private boolean inTransaction = false;
    Stack packetPool = new Stack();
    Stack packetPoolUnicode = new Stack();
    private boolean isUnicode = false;
    private SQLWarning warningList;
    private Properties connectProperties;
    private UniqueID UniqueID = new UniqueID();
    private Map typeMap;
    private Object executingObject = null;
    protected boolean inReconnect = false;
    private boolean isFetchLastNewStyleSupported = false;
    private GarbageParseid garbageParseids = null;
    private GarbageCursor garbageCursors = null;
    ArrayList statementContainer = null;
    private boolean keepGarbage = false;
    private int isolationLevel = 2;
    private int resultSetHoldability = 1;
    private int defaultResultSetType = 1003;
    ParseinfoCache parseCache = null;
    DbsCache dbsCache = null;
    int sessionID = -1;
    boolean isSQLModeOracle = false;
    boolean isSpaceoptionSet = false;
    private DatabaseMetaData DatabaseMetaData = null;
    private String cursorPrefix = "JDBC_CURSOR_";
    private static final String syncObj = "";
    private int nonRecyclingExecutions = 0;
    private int kernelversion;
    private byte[] kernelFeatures;
    private Object mClientInfo = null;
    private short dateTimeFormat;
    private boolean releaseSavePointSupported;
    boolean picky = false;
    private boolean sqlj;
    private boolean isTracingDiabled;
    public Tracer tracer;
    public TraceControl m_trcCtl;

    public ConnectionSapDB(JdbcCommunication session, Properties info, TraceControl mytrc) throws SQLException {
        this.session = session;
        this.m_trcCtl = mytrc;
        this.tracer = this.m_trcCtl.tracer;
        this.connectProperties = (Properties)info.clone();
        this.isSQLModeOracle = this.getConnectProperty("sqlmode").equalsIgnoreCase("oracle");
        this.isSpaceoptionSet = DriverSapDB.getBooleanProperty(this.connectProperties, "spaceoption", false);
        this.isTracingDiabled = DriverSapDB.getBooleanProperty(this.connectProperties, "disableTracing", false);
        this.defaultResultSetType = DriverSapDB.resultSetTypeString2Jdbc(this.connectProperties.getProperty("defaultresultsettype", String.valueOf(1003)));
        this.sqlj = DriverSapDB.getBooleanProperty(this.connectProperties, DriverSapDB.sqlj_C, false);
        if (!this.sqlj) {
            try {
                this.doConnect(this.connectProperties);
            }
            catch (SQLException e) {
                mytrc.tracer.traceException(e);
                throw e;
            }
        } else {
            this.attachToConnection();
        }
        this.statementContainer = new ArrayList();
    }

    final void addWarning(SQLWarning warning) {
        if (this.warningList == null) {
            this.warningList = warning;
        } else {
            this.warningList.setNextWarning(warning);
        }
    }

    protected void assertOpen() throws SQLException {
        if (this.session == null) {
            throw SQLExceptionSapDB.generateSQLException("error.objectisclosed", this);
        }
    }

    public final void cancel(Object requestingObject) throws SQLException {
        if (this.executingObject == requestingObject) {
            this.session.cancel();
        }
    }

    public final void cancel(Object r1, Object r2) throws SQLException {
        if (this.executingObject == r1 && r1 != null || this.executingObject == r2 && r2 != null) {
            this.session.cancel();
            return;
        }
    }

    public final void clearWarnings() throws SQLException {
        this.warningList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.sqlj) {
            return;
        }
        if (this.session != null) {
            try {
                if (this.garbageCursors != null) {
                    this.garbageCursors.emptyCan();
                }
                if (this.garbageParseids != null) {
                    this.garbageParseids.emptyCan();
                }
                this.executeSQLString("ROLLBACK WORK RELEASE", 3);
            }
            catch (SQLException sqlExc) {
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                this.releaseSession();
            }
        }
    }

    void releaseSession() {
        this.session.release();
        this.session = null;
        this.DatabaseMetaData = null;
    }

    boolean closeCursorAtCommit() throws SQLException {
        boolean forceGC = false;
        int sz = this.statementContainer.size();
        for (int i = 0; i < sz; ++i) {
            StatementSapDB st = (StatementSapDB)((WeakReference)this.statementContainer.get(i)).get();
            if (st == null) continue;
            ResultSet rs = st.currentResultSet;
            if (st.getResultSetHoldability() != 2 || rs == null) continue;
            forceGC = true;
            rs.close();
        }
        this.statementContainer.clear();
        if (forceGC && this.garbageCursors != null) {
            this.garbageCursors.forceGarbageCollection();
        }
        return forceGC;
    }

    public synchronized void commit() throws SQLException {
        this.assertOpen();
        this.closeCursorAtCommit();
        this.executeSQLString("COMMIT WORK", 1);
        this.inTransaction = false;
    }

    public Statement createStatement() throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new StatementSapDBFinalize(this, this.defaultResultSetType, 1007, 1);
        }
        return new StatementSapDB(this, this.defaultResultSetType, 1007, 1);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new StatementSapDBFinalize(this, resultSetType, resultSetConcurrency, 1);
        }
        return new StatementSapDB(this, resultSetType, resultSetConcurrency, 1);
    }

    private String getTermID() {
        StringBuffer termidsb = new StringBuffer(18);
        if (DriverSapDB.processid == 0) {
            termidsb.append("java@");
            termidsb.append(Integer.toHexString(this.hashCode()));
        } else {
            termidsb.append(DriverSapDB.processid);
            termidsb.append('@');
            termidsb.append(DriverSapDB.fullcomputername);
            if (termidsb.length() > 18) {
                termidsb.delete(18, termidsb.length());
            }
        }
        while (termidsb.length() < 18) {
            termidsb.append(' ');
        }
        return termidsb.toString();
    }

    protected void attachToConnection() throws SQLException {
        RequestPacket requestPacket = this.getRequestPacket(false);
        requestPacket.initDbsCommandThrowSQLExc(false, "CONNECT", 1003);
        ReplyPacket replyPacket = this.execute(requestPacket, this, 2);
        this.autocommit = false;
        this.cursorPrefix = "SYSSQLJ_";
        this.sessionID = replyPacket.getSessionID();
        this.isUnicode = replyPacket.supportsKernelUnicode();
        this.dateTimeFormat = replyPacket.getDateTimeFormat();
        if (this.dateTimeFormat != 2 && this.dateTimeFormat != 1) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.datetimeformat", DateTimeFormat.toString[this.dateTimeFormat]);
        }
        VersionInfo vi = new VersionInfo(replyPacket.getKernelMajorVersion(), replyPacket.getKernelMinorVersion(), replyPacket.getKernelCorrectionLevel(), 0, null);
        if (vi.getMajorVersion() >= 7 && vi.getMinorVersion() >= 6) {
            this.DatabaseMetaData = new DatabaseMetaDataMaxDB(this, vi);
            this.setFetchLastNewStyleSupported(true);
        } else {
            this.DatabaseMetaData = new DatabaseMetaDataSapDB(this, vi);
        }
        this.releaseSavePointSupported = true;
        this.kernelversion = vi.getMajorVersion() * 10000 + 100 * vi.getMinorVersion() + vi.getMinorMinorVersion();
        this.kernelFeatures = replyPacket.getFeatures();
    }

    protected void doConnect(Properties info) throws SQLException {
        String currentSchema;
        byte[] features;
        String userRaw = info.getProperty("user");
        if (userRaw == null || userRaw.length() == 0) {
            throw SQLExceptionSapDB.generateSQLException("error.nouser");
        }
        String userEscaped = NameHandling.stripUsernameEscaped(userRaw);
        String passwd = info.getProperty("password");
        if (passwd == null) {
            throw SQLExceptionSapDB.generateSQLException("error.nopassword");
        }
        boolean isUserPasswdAscii = StringUtil.isIso8859_1(passwd);
        if (isUserPasswdAscii) {
            isUserPasswdAscii = StringUtil.isIso8859_1(userEscaped);
        }
        String strippedPassword = NameHandling.stripPassword(passwd);
        String sqlMode = info.getProperty("sqlmode", "INTERNAL");
        String cacheLimit = info.getProperty("cachelimit");
        String timeout = info.getProperty("timeout");
        String isolationLevel = info.getProperty("isolation");
        this.picky = DriverSapDB.getBooleanProperty(info, "picky", false);
        RequestPacket requestPacket = this.getRequestPacket(!isUserPasswdAscii);
        AuthenticationManagerInterface authMan = null;
        boolean isAdvancedAuthenticationSupported = false;
        if (this.session.isAdvancedAuthenticationSupported()) {
            try {
                authMan = info.getProperty("transport", syncObj).equalsIgnoreCase("NATIVE") ? new NativeAuthenticationManager(this, userRaw, strippedPassword, isUserPasswdAscii) : new AuthenticationManager(this, userEscaped, passwd, isUserPasswdAscii);
                isAdvancedAuthenticationSupported = true;
                int maxpwdLen = authMan.getMaxPasswordLength();
                if (maxpwdLen != -1 && strippedPassword.length() > maxpwdLen) {
                    strippedPassword = strippedPassword.substring(0, maxpwdLen);
                }
            }
            catch (SQLExceptionSapDB e) {
                isAdvancedAuthenticationSupported = false;
                if (e.getErrorCode() == -5015) {
                    try {
                        this.session.reconnect();
                    }
                    catch (RTEException rteEx) {
                        throw ConnectionException.createException(rteEx);
                    }
                }
                throw e;
            }
        }
        if (DriverSapDB.getBooleanProperty(info, "authentication", false) && !isAdvancedAuthenticationSupported) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.challengeresponsenotsupported");
        }
        String connectCmd = "Connect " + (!isAdvancedAuthenticationSupported ? "\"" + userEscaped + "\"" : "?") + " identified by ? " + "SQLMODE " + sqlMode;
        if (timeout != null) {
            connectCmd = connectCmd + " TIMEOUT " + timeout;
        }
        if (isolationLevel != null) {
            this.isolationLevel = DriverSapDB.isolevelString2Jdbc(isolationLevel);
            connectCmd = connectCmd + " ISOLATION LEVEL " + DriverSapDB.isolevelJdbc2native(this.isolationLevel);
        }
        if (cacheLimit != null) {
            connectCmd = connectCmd + " CACHELIMIT " + cacheLimit;
        }
        if (this.isSpaceoptionSet) {
            connectCmd = connectCmd + " SPACE OPTION ";
            features = new byte[20];
            features[18] = 2;
            features[19] = 1;
        } else {
            features = new byte[18];
        }
        requestPacket.initDbsCommandThrowSQLExc(false, connectCmd, 1003);
        if (!isAdvancedAuthenticationSupported) {
            byte[] crypted;
            try {
                crypted = NameHandling.mangle(passwd, !isUserPasswdAscii);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                throw SQLExceptionSapDB.generateSQLException("error.invalidpassword");
            }
            requestPacket.newPart(5);
            requestPacket.addDataBytes(crypted);
            requestPacket.addDataString(this.getTermID());
            requestPacket.incrPartArguments();
        } else {
            authMan.addClientProofPart(requestPacket, NameHandling.stripUsername(userRaw), strippedPassword, !isUserPasswdAscii);
            requestPacket.addClientIDPart(this.getTermID());
        }
        features[0] = 3;
        features[1] = 1;
        features[2] = 1;
        features[3] = 1;
        features[4] = 5;
        features[5] = DriverSapDB.getBooleanProperty(info, "disableselectfetchoptimize", false) ? (byte)0 : 1;
        features[6] = 6;
        features[7] = 1;
        features[8] = 7;
        features[9] = 1;
        features[10] = 9;
        features[11] = 1;
        features[12] = 11;
        features[13] = 1;
        features[14] = 12;
        features[15] = 1;
        features[16] = 13;
        features[17] = 1;
        requestPacket.addFeatureRequestPart(features);
        ReplyPacket replyPacket = this.execute(requestPacket, this, 2);
        this.sessionID = replyPacket.getSessionID();
        this.isUnicode = replyPacket.supportsKernelUnicode();
        this.kernelFeatures = replyPacket.getFeatures();
        this.dateTimeFormat = replyPacket.getDateTimeFormat();
        if (this.dateTimeFormat != 2 && this.dateTimeFormat != 1) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.datetimeformat", DateTimeFormat.toString[this.dateTimeFormat]);
        }
        VersionInfo vi = new VersionInfo(replyPacket.getKernelMajorVersion(), replyPacket.getKernelMinorVersion(), replyPacket.getKernelCorrectionLevel(), 0, null);
        if (vi.getMajorVersion() >= 7 && vi.getMinorVersion() >= 6) {
            this.DatabaseMetaData = new DatabaseMetaDataMaxDB(this, vi);
            this.setFetchLastNewStyleSupported(true);
        } else {
            this.DatabaseMetaData = new DatabaseMetaDataSapDB(this, vi);
        }
        this.releaseSavePointSupported = true;
        this.kernelversion = vi.getMajorVersion() * 10000 + 100 * vi.getMinorVersion() + vi.getMinorMinorVersion();
        this.autocommit = DriverSapDB.getBooleanProperty(info, "autocommit", this.autocommit);
        if (info.containsKey("cache")) {
            this.parseCache = new ParseinfoCache(info);
        }
        if ((currentSchema = info.getProperty("currentschema")) != null && currentSchema.length() != 0) {
            String cmd = "SET CURRENT_SCHEMA = " + currentSchema;
            InternalStatementSapDB setIso = new InternalStatementSapDB(this);
            setIso.executeUpdate(cmd);
        }
    }

    public ReplyPacket execute(RequestPacket requestPacket, Object executingObject, int gcFlags) throws SQLException {
        return this.execute(requestPacket, false, false, executingObject, gcFlags);
    }

    public ReplyPacket sendStreamErrorPacket(SQLException sqlEx) {
        try {
            RequestPacket requestPacket = this.getRequestPacket(false);
            requestPacket.initDbs(this.autocommit, 1003);
            if (sqlEx.getMessage() == null || sqlEx.getMessage().length() == 0) {
                requestPacket.addErrorTextPart(MessageTranslator.translate("error.message.notavailable"));
            } else {
                requestPacket.addErrorTextPart(sqlEx.getMessage());
            }
            if (sqlEx.getErrorCode() == 0) {
                requestPacket.setErrorCode(-9999);
                requestPacket.setSQLState("S9999");
            } else {
                requestPacket.setErrorCode(sqlEx.getErrorCode());
                requestPacket.setSQLState(sqlEx.getSQLState());
            }
            return this.execute(requestPacket, false, false, this, 3);
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyPacket execute(RequestPacket requestPacket, boolean ignoreErrors, boolean isParse, Object executingObject, int gcFlags) throws SQLException {
        this.m_communicationSemaphore.acquire();
        try {
            ReplyPacket replyPacket = null;
            int localWeakReturnCode = 0;
            this.assertOpen();
            if (!this.isTracingDiabled) {
                this.m_trcCtl.checkTraceSettings();
            }
            if (gcFlags == 1) {
                boolean spaceleft = true;
                if (this.garbageCursors != null && this.garbageCursors.isPending()) {
                    if (this.inReconnect) {
                        this.garbageCursors.emptyCan();
                    } else {
                        try {
                            spaceleft = this.garbageCursors.emptyCan(requestPacket);
                        }
                        catch (UnicodeConversionException e) {
                            // empty catch block
                        }
                    }
                }
                if (spaceleft && this.garbageParseids != null && this.garbageParseids.isPending()) {
                    if (this.inReconnect) {
                        this.garbageParseids.emptyCan();
                    } else {
                        this.garbageParseids.emptyCan(requestPacket);
                    }
                }
            } else if (this.garbageParseids != null && this.garbageParseids.isPending()) {
                ++this.nonRecyclingExecutions;
            }
            requestPacket.closePacket();
            int requestLen = requestPacket.length();
            try {
                this.executingObject = executingObject;
                replyPacket = ReplyPacketFactory.getReplyPacket(this.session.execute(requestPacket.getBase(), requestLen), this.isKernelFeaturesupported(6), this.isKernelFeaturesupported(13));
                replyPacket.firstSegment();
                localWeakReturnCode = replyPacket.weakReturnCode();
                if (localWeakReturnCode == 1) {
                    String res = replyPacket.toString();
                    throw new SQLException("Wrong packet recieved. " + res, "0A007", 1);
                }
                if (localWeakReturnCode != -8) {
                    this.freeRequestPacket(requestPacket);
                }
                if (!this.autocommit && !isParse) {
                    this.inTransaction = true;
                }
                if (gcFlags != 3) {
                    if (this.garbageCursors != null && this.garbageCursors.isPending() && localWeakReturnCode == 0) {
                        if (this.inReconnect) {
                            this.garbageCursors.emptyCan();
                        } else {
                            this.garbageCursors.emptyCan(this);
                        }
                    }
                    if (this.nonRecyclingExecutions > 20 && localWeakReturnCode == 0) {
                        this.nonRecyclingExecutions = 0;
                        if (this.garbageParseids != null && this.garbageParseids.isPending()) {
                            if (this.inReconnect) {
                                this.garbageParseids.emptyCan();
                            } else {
                                this.garbageParseids.emptyCan(this);
                            }
                        }
                        this.nonRecyclingExecutions = 0;
                    }
                }
            }
            catch (RTEException rteExc) {
                if (!DriverSapDB.getBooleanProperty(this.connectProperties, "reconnect", true) || this.inReconnect || this.inTransaction) {
                    throw ConnectionException.createException(rteExc);
                }
                this.tryReconnect(rteExc);
                this.inTransaction = false;
            }
            finally {
                this.executingObject = null;
            }
            if (!ignoreErrors && localWeakReturnCode != 0) {
                this.throwSQLError(replyPacket);
            }
            ReplyPacket replyPacket2 = replyPacket;
            return replyPacket2;
        }
        finally {
            this.m_communicationSemaphore.release();
        }
    }

    private void executeSQLString(String cmd, int gcFlags) throws SQLException {
        block6: {
            RequestPacket requestPacket = this.getRequestPacket(false);
            try {
                requestPacket.initDbs(this.autocommit, 1003);
                requestPacket.addStringThrowExc(cmd);
            }
            catch (UnicodeConversionException e) {
                this.freeRequestPacket(requestPacket);
                requestPacket = this.getRequestPacket(true);
                requestPacket.initDbs(this.autocommit, 1003);
                try {
                    requestPacket.addStringThrowExc(cmd);
                }
                catch (UnicodeConversionException e1) {
                    throw SQLExceptionSapDB.generateSQLException("error.unicodetoAscii", cmd);
                }
            }
            try {
                this.execute(requestPacket, this, gcFlags);
            }
            catch (SQLException ignore) {
                if (ignore.getErrorCode() == 700) break block6;
                throw ignore;
            }
        }
    }

    public void freeRequestPacket(RequestPacket requestPacket) {
        if (requestPacket.isUnicodePacket()) {
            this.packetPoolUnicode.push(requestPacket);
        } else {
            this.packetPool.push(requestPacket);
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    public final String getCatalog() throws SQLException {
        return null;
    }

    final String getConnectProperty(String key) {
        return this.connectProperties.getProperty(key, syncObj);
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpen();
        return this.DatabaseMetaData;
    }

    public final synchronized RequestPacket getRequestPacket(boolean forceUnicode) throws SQLException {
        RequestPacket result;
        String applID = this.connectProperties.getProperty("application", null);
        String applVers = this.connectProperties.getProperty("appversion", null);
        this.assertOpen();
        try {
            result = forceUnicode ? (this.packetPoolUnicode.isEmpty() ? new RequestPacketUnicode(this.session.getRequestPacket(), applID, applVers) : (RequestPacket)this.packetPoolUnicode.pop()) : (this.packetPool.isEmpty() ? new RequestPacket(this.session.getRequestPacket(), 0, applID, applVers) : (RequestPacket)this.packetPool.pop());
        }
        catch (RTEException rteExc) {
            throw ConnectionException.createException(rteExc);
        }
        return result;
    }

    public final int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public final Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.warningList;
    }

    public boolean isClosed() throws SQLException {
        block5: {
            if (this.session == null) {
                return true;
            }
            try {
                RequestPacket requestPacket = this.getRequestPacket(false);
                requestPacket.initHello();
                this.execute(requestPacket, this, 1);
            }
            catch (SQLException exc) {
                if (exc.getErrorCode() == 700) break block5;
                try {
                    this.session.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.session = null;
                this.DatabaseMetaData = null;
                return true;
            }
        }
        return this.session == null;
    }

    public final boolean isReadOnly() throws SQLException {
        return false;
    }

    boolean isInTransaction() {
        return !this.autocommit && this.inTransaction;
    }

    final synchronized int maxStatementLength() throws SQLException {
        RequestPacket requestPacket = this.getRequestPacket(false);
        int packetSize = requestPacket.size();
        int result = packetSize - 32 - 40 - 16;
        this.freeRequestPacket(requestPacket);
        return result;
    }

    public final String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    final String nextCursorName() {
        return this.UniqueID.getNextID(this.cursorPrefix);
    }

    protected final void setCursorPrefix(String prefix) {
        this.cursorPrefix = prefix;
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, this.defaultResultSetType, 1007, 1);
        }
        return new CallableStatementSapDB(this, sql, this.defaultResultSetType, 1007, 1);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, 1);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, 1);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, this.defaultResultSetType, 1007, 1);
        }
        return new CallableStatementSapDB(this, sql, this.defaultResultSetType, 1007, 1);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, 1);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, 1);
    }

    public void rollback() throws SQLException {
        this.assertOpen();
        this.executeSQLString("ROLLBACK WORK", 1);
        this.inTransaction = false;
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertOpen();
        this.connectProperties.setProperty("autocommit", autoCommit ? "TRUE" : "FALSE");
        if (autoCommit) {
            this.commit();
        }
        this.autocommit = autoCommit;
    }

    public final void setCatalog(String catalog) throws SQLException {
    }

    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpen();
    }

    public final void setTransactionIsolation(int level) throws SQLException {
        if (this.isolationLevel != level) {
            this.connectProperties.setProperty("isolation", String.valueOf(level));
            String sapdbEncoding = DriverSapDB.isolevelJdbc2native(level);
            this.assertOpen();
            String cmd = "SET ISOLATION LEVEL " + sapdbEncoding;
            InternalStatementSapDB setIso = new InternalStatementSapDB(this);
            setIso.executeUpdate(cmd);
            this.isolationLevel = level;
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    final void throwBatchException(ReplyPacket replyPacket, int[] codes, int segmentsProcessed) throws BatchUpdateException {
        String state = replyPacket.sqlState();
        int rc = replyPacket.returnCode();
        String errmsg = replyPacket.getErrorMsg();
        int[] firstCodes = new int[segmentsProcessed];
        System.arraycopy(codes, 0, firstCodes, 0, segmentsProcessed);
        throw new BatchUpdateException(errmsg, state, rc, firstCodes);
    }

    private final void throwSQLError(ReplyPacket replyPacket) throws SQLException {
        SQLException exc = replyPacket.createException();
        throw exc;
    }

    public void tryReconnect(RTEException outerRteExc) throws SQLException {
        String string = syncObj;
        synchronized (syncObj) {
            SQLException timeout = SQLExceptionSapDB.generateSQLException("error.timeout");
            if (this.parseCache != null) {
                this.parseCache.clear();
            }
            if (this.dbsCache != null) {
                this.dbsCache.clear();
            }
            if (this.garbageCursors != null) {
                this.garbageCursors.emptyCan();
            }
            if (this.garbageParseids != null) {
                this.garbageParseids.emptyCan();
            }
            this.packetPool.setSize(0);
            this.packetPoolUnicode.setSize(0);
            this.inReconnect = true;
            try {
                this.session.reconnect();
                this.tracer.print("try to reconnect ", this.connectProperties);
                this.doConnect(this.connectProperties);
            }
            catch (RTEException rteExc) {
                throw ConnectionException.createException(rteExc);
            }
            finally {
                this.inReconnect = false;
            }
            throw timeout;
        }
    }

    public final void dropParseid(byte[] pid) {
        if (!this.keepGarbage) {
            if (pid == null) {
                return;
            }
            if (this.garbageParseids == null) {
                this.garbageParseids = new GarbageParseid(this.isKernelFeaturesupported(1));
            }
            this.garbageParseids.throwIntoGarbageCan(pid);
        }
        if (this.sqlj) {
            this.garbageParseids.forceGarbageCollection();
            this.garbageParseids.emptyCan(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCursor(String cursorname, boolean forceGarbageCollection) {
        ConnectionSapDB connectionSapDB = this;
        synchronized (connectionSapDB) {
            if (this.garbageCursors == null) {
                this.garbageCursors = new GarbageCursor();
            }
            this.garbageCursors.throwIntoGarbageCan(cursorname);
            if (this.sqlj || forceGarbageCollection) {
                this.garbageCursors.forceGarbageCollection();
                this.garbageCursors.emptyCan(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean restoreCursor(String cursorname) {
        ConnectionSapDB connectionSapDB = this;
        synchronized (connectionSapDB) {
            if (this.garbageCursors != null) {
                return this.garbageCursors.restoreFromGarbageCan(cursorname);
            }
            return false;
        }
    }

    public void printCacheStats(PrintStream stream) {
        if (this.parseCache == null) {
            stream.println("no cache available");
        } else {
            this.parseCache.dumpStats(stream);
        }
    }

    public void printCacheStats(PrintWriter stream) {
        if (this.parseCache == null) {
            stream.println("no cache available");
        } else {
            this.parseCache.dumpStats(stream);
        }
    }

    public boolean isSQLModeOracle() {
        return this.isSQLModeOracle;
    }

    public void setHoldability(int holdability) throws SQLException {
        this.resultSetHoldability = holdability;
    }

    public int getHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.getAutoCommit()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.autocommit");
        }
        return SavepointSapDB.setSavepoint(this);
    }

    public Savepoint setSavepoint(String SavepointName) throws SQLException {
        if (this.getAutoCommit()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.autocommit");
        }
        return SavepointSapDB.setSavepoint(SavepointName, this);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.autocommit");
        }
        SavepointSapDB.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        SavepointSapDB.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new StatementSapDBFinalize(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new StatementSapDB(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        if (DriverSapDB.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.preparestatement.notimplemented"));
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
    }

    public void reinitialize() throws SQLException {
        String isolation;
        int preset_isolationlevel;
        if (this.parseCache != null) {
            Object[] parseInfos = this.parseCache.clearAll();
            for (int i = 0; i < parseInfos.length; ++i) {
                ((Parseinfo)parseInfos[i]).dropParseIDs();
            }
        }
        int n = preset_isolationlevel = (isolation = this.connectProperties.getProperty("isolation")) == null ? 2 : DriverSapDB.isolevelString2Jdbc(isolation);
        if (preset_isolationlevel != this.getTransactionIsolation()) {
            this.setTransactionIsolation(preset_isolationlevel);
        }
        this.setAutoCommit(DriverSapDB.getBooleanProperty(this.connectProperties, "autocommit", true));
        this.resultSetHoldability = 1;
        this.typeMap = null;
    }

    int getKernelVersion() {
        return this.kernelversion;
    }

    public boolean isKernelFeaturesupported(int feature) {
        if (this.kernelFeatures == null) {
            return false;
        }
        boolean erg = this.kernelFeatures[2 * (feature - 1) + 1] == 1;
        return erg;
    }

    void stopKernelTrace() {
        try {
            this.executeSQLString("DIAGNOSE VTRACE FLUSH", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Properties getConnectProperties() {
        return this.connectProperties;
    }

    public boolean isReleaseSavePointSupported() {
        return this.releaseSavePointSupported;
    }

    public void setReleaseSavePointSupported(boolean value) {
        this.releaseSavePointSupported = false;
    }

    void setInTransaction(boolean inTransaction) {
        this.inTransaction = inTransaction;
    }

    public String toString() {
        if (this.session != null) {
            return super.toString() + "[T" + this.session.getKernelTaskID() + "]";
        }
        return super.toString();
    }

    public boolean isFetchLastNewStyleSupported() {
        return this.isFetchLastNewStyleSupported;
    }

    public void setFetchLastNewStyleSupported(boolean isFetchLastNewStyleSupported) {
        this.isFetchLastNewStyleSupported = isFetchLastNewStyleSupported;
    }

    public boolean isUnicodeSupported() {
        return this.isUnicode;
    }

    public void setPicky(boolean picky) {
        this.picky = picky;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && ((ConnectionSapDB)obj).sessionID == this.sessionID;
    }

    public boolean isDateTimeFormatInternal() {
        return this.isKernelFeaturesupported(7) || this.dateTimeFormat == 1;
    }

    public Properties getClientInfo() throws SQLException {
        return ClientInfo.getClientInfo(this.mClientInfo);
    }

    public String getClientInfo(String name) throws SQLException {
        return ClientInfo.getClientInfo(this.mClientInfo, name);
    }

    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(timeout));
        }
        return !this.isClosed();
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.mClientInfo = ClientInfo.setClientInfo(this.mClientInfo, properties);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.mClientInfo = ClientInfo.setClientInfo(this.mClientInfo, name, value);
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createArrayOf", "ConnectionSapDB");
    }

    public Blob createBlob() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createBlob", "ConnectionSapDB");
    }

    public Clob createClob() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createClob", "ConnectionSapDB");
    }

    public NClob createNClob() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createNClob", "ConnectionSapDB");
    }

    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createSQLXML", "ConnectionSapDB");
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createStruct", "ConnectionSapDB");
    }

    public boolean isSQLJ() {
        return this.sqlj;
    }

    public boolean isSpaceoptionSet() {
        return this.isSpaceoptionSet;
    }

    public int getSessionID() {
        return this.sessionID;
    }
}

