/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbm;

import com.sap.dbtech.powertoys.DBM;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class DBMUtils {
    private String displayDetectedRoots = "";
    private String displayDetectedFileIds = "";
    private String queryDetectedRoots = "";
    private String queryDetectedFileIds = "";
    private String dbServer;
    private String dbName;
    private String dbmUser;
    private String dbmPwd;
    private DBM session;
    private boolean lastConnectionOK = false;

    public String getDisplayDetectedRoots() {
        return this.displayDetectedRoots;
    }

    public String getDisplayDetectedFileIds() {
        return this.displayDetectedFileIds;
    }

    public String getQueryDetectedRoots() {
        return this.queryDetectedRoots;
    }

    public String getQueryDetectedFileIds() {
        return this.queryDetectedFileIds;
    }

    public boolean isLastConnectionOK() {
        return this.lastConnectionOK;
    }

    public static void main(String[] args) {
    }

    public String getRunDirectory() {
        String runDir = "";
        try {
            runDir = this.session.cmd("param_getvalue rundirectory");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return runDir;
    }

    public void createDBMConnection(String dbserver, String dbname, String dbmuser, String dbmpwd) {
        try {
            this.session = DBM.dbDBM(dbserver, dbname);
            this.session.cmd("user_logon " + dbmuser + "," + dbmpwd);
            this.dbServer = dbserver;
            this.dbName = dbname;
            this.dbmUser = dbmuser;
            this.dbmPwd = dbmpwd;
            this.lastConnectionOK = true;
        }
        catch (Exception e) {
            this.lastConnectionOK = false;
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public void closeDBMConnection() {
        try {
            this.session.release();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public String getLastBackupSetForRecovery() {
        String result = "";
        try {
            this.session.cmd("backup_history_open -e");
            result = this.session.cmd("backup_history_list -r last -c label,action,pages,stop,media");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return result;
    }

    public void searchReportedObjects(int logversion, String startDate) {
        String[] nextLogRead;
        this.displayDetectedRoots = "";
        this.displayDetectedFileIds = "";
        this.queryDetectedRoots = "";
        this.queryDetectedFileIds = "";
        String rootToAdd = "";
        String fileIDToAdd = "";
        Pattern pRoots = null;
        Pattern pFileids = null;
        Matcher mRoots = null;
        Matcher mFfileids = null;
        Boolean moreLogToRead = true;
        String logReadResult = null;
        int rootCount = 0;
        int fileidCount = 0;
        if (logversion == 2) {
            try {
                logReadResult = this.session.cmd("file_getfirst KNLMSGARC");
                pRoots = Pattern.compile("(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*root\\s\\'(\\d*[0-9])\\'|\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*ROOT=(\\d*[0-9]))");
                pFileids = Pattern.compile("(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*fileID\\s\\'(................)\\'|\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*FILENO=(................))");
                while (moreLogToRead.booleanValue()) {
                    mRoots = pRoots.matcher(logReadResult);
                    mFfileids = pFileids.matcher(logReadResult);
                    while (mRoots.find()) {
                        if (mRoots.group(2) != null && mRoots.group(3) == null) {
                            rootToAdd = mRoots.group(2);
                        } else if (mRoots.group(2) == null && mRoots.group(3) != null) {
                            rootToAdd = mRoots.group(3);
                        }
                        if (mRoots.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedRoots.contains(rootToAdd)) continue;
                        if (!this.displayDetectedRoots.isEmpty()) {
                            this.queryDetectedRoots = this.queryDetectedRoots + ",'" + rootToAdd + "'";
                            this.displayDetectedRoots = this.displayDetectedRoots + " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                            ++rootCount;
                            continue;
                        }
                        this.queryDetectedRoots = "'" + rootToAdd + "'";
                        this.displayDetectedRoots = " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                        ++rootCount;
                    }
                    while (mFfileids.find()) {
                        if (mFfileids.group(2) != null && mFfileids.group(3) == null) {
                            fileIDToAdd = mFfileids.group(2);
                        } else if (mFfileids.group(2) == null && mFfileids.group(3) != null) {
                            fileIDToAdd = mFfileids.group(3);
                        }
                        if (mFfileids.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedFileIds.contains(fileIDToAdd)) continue;
                        if (!this.displayDetectedFileIds.isEmpty()) {
                            this.queryDetectedFileIds = this.queryDetectedFileIds + ",x'" + fileIDToAdd + "'";
                            this.displayDetectedFileIds = this.displayDetectedFileIds + " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + fileIDToAdd + "'" + "\n";
                            ++fileidCount;
                            continue;
                        }
                        this.queryDetectedFileIds = "x'" + fileIDToAdd + "'";
                        this.displayDetectedFileIds = " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + fileIDToAdd + "'" + "\n";
                        ++fileidCount;
                    }
                    nextLogRead = logReadResult.split("\\n");
                    if (nextLogRead[1].toString().contains("END")) {
                        moreLogToRead = false;
                        continue;
                    }
                    logReadResult = this.session.cmd("file_getnext KNLMSGARC 1");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
            }
            if (!this.displayDetectedRoots.isEmpty()) {
                this.displayDetectedRoots = this.displayDetectedRoots + "\n" + " Total: " + rootCount;
            }
            if (!this.displayDetectedFileIds.isEmpty()) {
                this.displayDetectedFileIds = this.displayDetectedFileIds + "\n" + " Total: " + fileidCount;
            }
        }
        if (logversion == 1) {
            try {
                logReadResult = this.session.cmd("file_getfirst KNLDIAGERR");
                rootToAdd = "";
                fileIDToAdd = "";
                while (moreLogToRead.booleanValue()) {
                    pRoots = Pattern.compile("(2[0-9][0-9][0-9](-0[1-9]|-1[0-9])(-0[1-9]|-1[0-9]|-2[0-9]|-3[0-1]).*Root\\s\\s(\\d*[0-9])|.*Bad\\sFile:\\s(\\d*[0-9])|.*Bad\\sIndex\\s(\\d*[0-9]))");
                    pFileids = Pattern.compile("(2[0-9][0-9][0-9](-0[1-9]|-1[0-9])(-0[1-9]|-1[0-9]|-2[0-9]|-3[0-1]).*FILENO=(................))");
                    mRoots = pRoots.matcher(logReadResult);
                    mFfileids = pFileids.matcher(logReadResult);
                    while (mRoots.find()) {
                        rootToAdd = mRoots.group(4) != null ? mRoots.group(4) : (mRoots.group(4) == null && mRoots.group(6) == null ? mRoots.group(5) : mRoots.group(6));
                        if (mRoots.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedRoots.contains(rootToAdd)) continue;
                        if (!this.displayDetectedRoots.isEmpty()) {
                            this.queryDetectedRoots = this.queryDetectedRoots + ",'" + rootToAdd + "'";
                            this.displayDetectedRoots = this.displayDetectedRoots + " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                            ++rootCount;
                            continue;
                        }
                        this.queryDetectedRoots = this.queryDetectedRoots + "'" + rootToAdd + "'";
                        this.displayDetectedRoots = " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                        ++rootCount;
                    }
                    while (mFfileids.find()) {
                        if (mRoots.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedFileIds.contains(mFfileids.group(4))) continue;
                        if (!this.displayDetectedFileIds.isEmpty()) {
                            this.queryDetectedFileIds = this.queryDetectedFileIds + ",x'" + mFfileids.group(4) + "'";
                            this.displayDetectedFileIds = this.displayDetectedFileIds + " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + mFfileids.group(4) + "'" + "\n";
                            ++fileidCount;
                            continue;
                        }
                        this.queryDetectedFileIds = "x'" + mFfileids.group(4) + "'";
                        this.displayDetectedFileIds = " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + mFfileids.group(4) + "'" + "\n";
                        ++fileidCount;
                    }
                    nextLogRead = logReadResult.split("\\n");
                    if (nextLogRead[1].toString().contains("END")) {
                        moreLogToRead = false;
                        continue;
                    }
                    logReadResult = this.session.cmd("file_getnext KNLDIAGERR 1");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
            }
            if (!this.displayDetectedRoots.isEmpty()) {
                this.displayDetectedRoots = this.displayDetectedRoots + "\n" + " Total: " + rootCount;
            }
            if (!this.displayDetectedFileIds.isEmpty()) {
                this.displayDetectedFileIds = this.displayDetectedFileIds + "\n" + " Total: " + fileidCount;
            }
        }
    }
}

