/*
 * Decompiled with CFR 0.152.
 */
package com.sap.utils;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;

public class Utils {
    public boolean containsOnlyNumbers(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isHexValue(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.matches("^[a-fA-F0-9_]+$");
    }

    public String formatFileID(String fileid) {
        String formattedFileID = fileid;
        int zerosToAdd = 16 - fileid.length();
        for (int i = 0; i < zerosToAdd; ++i) {
            formattedFileID = "0" + formattedFileID;
        }
        return "x'" + formattedFileID.toUpperCase() + "'";
    }

    private String scrambleUserKey(String usrKey) {
        String scrambledKey = "";
        if (usrKey.length() >= 16) {
            for (int i = 15; i >= 0; --i) {
                scrambledKey = scrambledKey + usrKey.charAt(i);
            }
        } else {
            int i;
            for (i = 0; i <= 15 - usrKey.length(); ++i) {
                scrambledKey = scrambledKey + i % 6;
            }
            for (i = usrKey.length() - 1; i >= 0; --i) {
                scrambledKey = scrambledKey + usrKey.charAt(i);
            }
        }
        return scrambledKey;
    }

    public String encrypt(String textToEncrypt, String encKey) {
        String returnEncText = "";
        try {
            SecretKeySpec myAesKey = new SecretKeySpec(this.scrambleUserKey(encKey).getBytes(), "AES");
            Cipher aesCipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            aesCipher.init(1, myAesKey);
            byte[] textToEncryptBytes = textToEncrypt.getBytes();
            byte[] encText = aesCipher.doFinal(textToEncryptBytes);
            returnEncText = Base64.encodeBase64String(encText);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error ocurred saving Server Data.");
        }
        return returnEncText;
    }

    public String decrypt(String textToDecrypt, String encKey) {
        String returnDecText = "";
        try {
            SecretKeySpec myAesKey = new SecretKeySpec(this.scrambleUserKey(encKey).getBytes(), "AES");
            Cipher aesCipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            aesCipher.init(2, myAesKey);
            byte[] textTodDecryptBytes = aesCipher.doFinal(Base64.decodeBase64(textToDecrypt));
            returnDecText = new String(textTodDecryptBytes);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error ocurred reading Server Data." + e.getMessage());
        }
        return returnDecText;
    }

    public String removeAllSpaces(String strToRemoveSpaces) {
        String strWithoutSpaces = "";
        for (int i = 0; i < strToRemoveSpaces.length(); ++i) {
            if (Character.isSpaceChar(strToRemoveSpaces.charAt(i))) continue;
            strWithoutSpaces = strWithoutSpaces + Character.valueOf(strToRemoveSpaces.charAt(i));
        }
        return strWithoutSpaces;
    }
}

