/*
 * Decompiled with CFR 0.152.
 */
package com.sap.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class DiagPackExtractor {
    public String extractErrorLog(String diagPackPath, int logVersion) {
        String returnFile = null;
        String fileToRecover = null;
        String fileToAnalyze = null;
        if (logVersion == 2) {
            fileToRecover = "KnlMsgArchive";
            fileToAnalyze = "knlmsgarchive_to_analyze";
        }
        if (logVersion == 1) {
            fileToRecover = "knldiag.err";
            fileToAnalyze = "knldiagerr_to_analyze";
        }
        int BUFFER = 2048;
        try {
            int count;
            File fileName = new File(diagPackPath);
            FileInputStream instream = new FileInputStream(fileName);
            GZIPInputStream ginstream = new GZIPInputStream(instream);
            TarArchiveInputStream tinstream = new TarArchiveInputStream(ginstream);
            TarArchiveEntry tarentry = tinstream.getNextTarEntry();
            while (!tarentry.getName().contains(fileToRecover)) {
                tarentry = tinstream.getNextTarEntry();
            }
            byte[] data = new byte[BUFFER];
            FileOutputStream fos = new FileOutputStream(fileToAnalyze);
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
            while ((count = tinstream.read(data, 0, BUFFER)) != -1) {
                dest.write(data, 0, count);
            }
            dest.close();
            returnFile = fileToAnalyze;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return returnFile;
    }
}

