/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.util.Tracer;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidSapDB
implements Xid {
    int formatId;
    byte[] gtrid;
    byte[] bqual;

    public XidSapDB(byte[] formatId, byte[] gtrid, byte[] bqual) {
        this.bqual = bqual;
        this.formatId = (formatId[0] & 0xFF) << 24 | (formatId[1] & 0xFF) << 16 | (formatId[2] & 0xFF) << 8 | (formatId[3] & 0xFF) << 0;
        this.gtrid = gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof XidSapDB)) {
            return false;
        }
        XidSapDB other = (XidSapDB)arg0;
        return this.formatId == other.formatId && Arrays.equals(this.gtrid, other.gtrid) && Arrays.equals(this.bqual, other.bqual);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SimpleXid(");
        sb.append("format=");
        sb.append(this.formatId);
        sb.append(",gtrid=[");
        sb.append(Tracer.Hex2String(this.gtrid));
        sb.append("],bqual=[");
        sb.append(Tracer.Hex2String(this.bqual));
        sb.append("])");
        return sb.toString();
    }
}

