/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimeTranslator;
import com.sap.dbtech.util.UnicodeUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class UnicodeTimeTranslator
extends TimeTranslator {
    UnicodeTimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getString(this.bufpos_output, this.physicalLength - 1);
        }
        return result;
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Time result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int hour = (raw[1] - 48) * 10;
            hour += raw[3] - 48;
            int min = (raw[7] - 48) * 10;
            min += raw[9] - 48;
            int sec = (raw[13] - 48) * 10;
            sec += raw[15] - 48;
            if (cal == null) {
                result = new Time(hour, min, sec);
            } else {
                cal.clear();
                cal.set(1970, 0, 1, hour, min, sec);
                result = DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
        }
        return result;
    }

    protected void putSpecific(DataPart dataPart, Object data) {
        dataPart.putDefineByte(1, this.bufpos_input - 1);
        dataPart.putUnicodeBytes((byte[])data, this.bufpos_input, this.physicalLength - 1);
    }

    public Object transTimeForInput(Time arg, Calendar cal) throws SQLException {
        if (arg == null) {
            return null;
        }
        byte[] chars = (byte[])super.transTimeForInput(arg, cal);
        byte[] bytes = UnicodeUtil.bytes2BigUnicode(chars);
        this.checkFieldLimits(bytes.length);
        return bytes;
    }
}

