/*
 * Decompiled with CFR 0.152.
 */
package com.sap.utils;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class LocalLogSearcher {
    private String displayDetectedRoots = "";
    private String displayDetectedFileIds = "";
    private String queryDetectedRoots = "";
    private String queryDetectedFileIds = "";

    public String getDisplayDetectedRoots() {
        return this.displayDetectedRoots;
    }

    public String getDisplayDetectedFileIds() {
        return this.displayDetectedFileIds;
    }

    public String getQueryDetectedRoots() {
        return this.queryDetectedRoots;
    }

    public String getQueryDetectedFileIds() {
        return this.queryDetectedFileIds;
    }

    public LocalLogSearcher(int logVersion, String fileName, String startDate) {
        Pattern pRoots = null;
        Pattern pFileids = null;
        Matcher mRoots = null;
        Matcher mFfileids = null;
        String logReadResult = null;
        String rootToAdd = "";
        String fileIDToAdd = "";
        int rootCount = 0;
        int fileidCount = 0;
        try {
            File log = new File(fileName);
            FileInputStream inFile = new FileInputStream(log);
            FileChannel inChannel = inFile.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(2048);
            if (logVersion == 2) {
                pRoots = Pattern.compile("(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*root\\s\\'(\\d*[0-9])\\'|\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*ROOT=(\\d*[0-9]))");
                pFileids = Pattern.compile("(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*fileID\\s\\'(................)\\'|\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d.*FILENO=(................))");
                while (inChannel.read(buf) != -1) {
                    buf.flip();
                    logReadResult = Charset.defaultCharset().decode(buf).toString();
                    mRoots = pRoots.matcher(logReadResult);
                    mFfileids = pFileids.matcher(logReadResult);
                    while (mRoots.find()) {
                        if (mRoots.group(2) != null && mRoots.group(3) == null) {
                            rootToAdd = mRoots.group(2);
                        } else if (mRoots.group(2) == null && mRoots.group(3) != null) {
                            rootToAdd = mRoots.group(3);
                        }
                        if (mRoots.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedRoots.contains(rootToAdd)) continue;
                        if (!this.displayDetectedRoots.isEmpty()) {
                            this.queryDetectedRoots = this.queryDetectedRoots + ",'" + rootToAdd + "'";
                            this.displayDetectedRoots = this.displayDetectedRoots + " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                            ++rootCount;
                            continue;
                        }
                        this.queryDetectedRoots = "'" + rootToAdd + "'";
                        this.displayDetectedRoots = " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                        ++rootCount;
                    }
                    while (mFfileids.find()) {
                        if (mFfileids.group(2) != null && mFfileids.group(3) == null) {
                            fileIDToAdd = mFfileids.group(2);
                        } else if (mFfileids.group(2) == null && mFfileids.group(3) != null) {
                            fileIDToAdd = mFfileids.group(3);
                        }
                        if (mFfileids.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedFileIds.contains(fileIDToAdd)) continue;
                        if (!this.displayDetectedFileIds.isEmpty()) {
                            this.queryDetectedFileIds = this.queryDetectedFileIds + ",x'" + fileIDToAdd + "'";
                            this.displayDetectedFileIds = this.displayDetectedFileIds + " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + fileIDToAdd + "'" + "\n";
                            ++fileidCount;
                            continue;
                        }
                        this.queryDetectedFileIds = "x'" + fileIDToAdd + "'";
                        this.displayDetectedFileIds = " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + fileIDToAdd + "'" + "\n";
                        ++fileidCount;
                    }
                    buf.clear();
                }
                inFile.close();
                if (!this.displayDetectedRoots.isEmpty()) {
                    this.displayDetectedRoots = this.displayDetectedRoots + "\n" + " Total: " + rootCount;
                }
                if (!this.displayDetectedFileIds.isEmpty()) {
                    this.displayDetectedFileIds = this.displayDetectedFileIds + "\n" + " Total: " + fileidCount;
                }
            }
            if (logVersion == 1) {
                pRoots = Pattern.compile("(2[0-9][0-9][0-9](-0[1-9]|-1[0-9])(-0[1-9]|-1[0-9]|-2[0-9]|-3[0-1]).*Root\\s\\s(\\d*[0-9])|.*Bad\\sFile:\\s(\\d*[0-9])|.*Bad\\sIndex\\s(\\d*[0-9]))");
                pFileids = Pattern.compile("(2[0-9][0-9][0-9](-0[1-9]|-1[0-9])(-0[1-9]|-1[0-9]|-2[0-9]|-3[0-1]).*FILENO=(................))");
                while (inChannel.read(buf) != -1) {
                    buf.flip();
                    logReadResult = Charset.defaultCharset().decode(buf).toString();
                    mRoots = pRoots.matcher(logReadResult);
                    mFfileids = pFileids.matcher(logReadResult);
                    while (mRoots.find()) {
                        rootToAdd = mRoots.group(4) != null ? mRoots.group(4) : (mRoots.group(4) == null && mRoots.group(6) == null ? mRoots.group(5) : mRoots.group(6));
                        if (mRoots.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedRoots.contains(rootToAdd)) continue;
                        if (!this.displayDetectedRoots.isEmpty()) {
                            this.queryDetectedRoots = this.queryDetectedRoots + ",'" + rootToAdd + "'";
                            this.displayDetectedRoots = this.displayDetectedRoots + " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                            ++rootCount;
                            continue;
                        }
                        this.queryDetectedRoots = this.queryDetectedRoots + "'" + rootToAdd + "'";
                        this.displayDetectedRoots = " Reported on: " + mRoots.group(1).substring(0, 20) + "     Root page number: '" + rootToAdd + "'" + "\n";
                        ++rootCount;
                    }
                    while (mFfileids.find()) {
                        if (mRoots.group(1).substring(0, 11).compareTo(startDate) < 0 || this.displayDetectedFileIds.contains(mFfileids.group(4))) continue;
                        if (!this.displayDetectedFileIds.isEmpty()) {
                            this.queryDetectedFileIds = this.queryDetectedFileIds + ",x'" + mFfileids.group(4) + "'";
                            this.displayDetectedFileIds = this.displayDetectedFileIds + " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + mFfileids.group(4) + "'" + "\n";
                            ++fileidCount;
                            continue;
                        }
                        this.queryDetectedFileIds = "x'" + mFfileids.group(4) + "'";
                        this.displayDetectedFileIds = " Reported on: " + mFfileids.group(1).substring(0, 20) + "     FILEID number: x'" + mFfileids.group(4) + "'" + "\n";
                        ++fileidCount;
                    }
                    buf.clear();
                }
                inFile.close();
                if (!this.displayDetectedRoots.isEmpty()) {
                    this.displayDetectedRoots = this.displayDetectedRoots + "\n" + " Total: " + rootCount;
                }
                if (!this.displayDetectedFileIds.isEmpty()) {
                    this.displayDetectedFileIds = this.displayDetectedFileIds + "\n" + " Total: " + fileidCount;
                }
            }
            log.delete();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }
}

