/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.util.StructuredBytes;

class ConnectPacket
extends StructuredBytes {
    private int writePos = 40;

    public ConnectPacket(byte[] buf, String serverdb, PacketLayout layout, int port, int serviceType) {
        super(buf, 24);
        this.putInt1(0, 0);
        this.putInt1(1, 1);
        this.putInt2(8236, 2);
        this.putInt1(serviceType, 4);
        this.putInt1(13, 5);
        this.putInt1(0, 6);
        this.putInt1(0, 7);
        this.putInt4(layout.maxSegmentSize(), 8);
        this.putInt4(layout.maxDataLength(), 12);
        this.putInt4(layout.packetSize(), 16);
        this.putInt4(layout.minReplySize(), 20);
        String smallServerdb = serverdb;
        if (serverdb.length() > 8) {
            smallServerdb = serverdb.substring(0, 6) + "..";
        }
        this.putString(smallServerdb, 24, 8);
        this.putString("        ", 32, 8);
        this.addConnectInt(DriverSapDB.processid, 73);
        this.addPort(port, 80);
        this.addFlagOmitReplyPart(114);
        this.addStringToVarpart(88, serverdb);
    }

    public void addBoolToVarpart(boolean ack, int tag) {
        int boolAsInt = ack ? 1 : 0;
        this.putInt1(3, this.writePos);
        this.putInt1(tag, this.writePos + 1);
        this.putInt1(boolAsInt, this.writePos + 2);
        this.writePos += 3;
    }

    public void addConnectInt(int value, int tag) {
        this.addConnectString(String.valueOf(value), tag);
    }

    public void addConnectString(String value, int tag) {
        int fullLength = value.length() + 3;
        this.putInt1(fullLength, this.writePos);
        this.putInt1(tag, this.writePos + 1);
        this.putString(value, this.writePos + 2);
        this.putInt1(0, this.writePos + fullLength - 1);
        this.writePos += fullLength;
    }

    public void addPort(int port, int tag) {
        this.putInt1(4, this.writePos);
        this.putInt1(tag, this.writePos + 1);
        this.putInt1(port / 256, this.writePos + 2);
        this.putInt1(port % 256, this.writePos + 3);
        this.writePos += 4;
    }

    public void addFlagOmitReplyPart(int tag) {
        this.putInt1(3, this.writePos);
        this.putInt1(tag, this.writePos + 1);
        this.putInt1(1, this.writePos + 2);
        this.writePos += 3;
    }

    public void addStringToVarpart(int tag, String value) {
        int len = 2 + value.length();
        this.putInt1(len + 1, this.writePos);
        this.putInt1(tag, this.writePos + 1);
        this.putString(value, this.writePos + 2);
        this.putInt1(0, this.writePos + len);
        this.writePos += len + 1;
    }

    public int length() {
        return this.writePos;
    }

    void close() {
        int currentLength = this.length();
        int requiredLength = 40;
        if (currentLength < 40) {
            this.writePos += 40 - currentLength;
        }
        this.putInt2(this.writePos, 2);
    }
}

