/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.dbtech.jdbcext.ConnectionListenerBag;
import com.sap.dbtech.jdbcext.XADataSourceSapDB;
import com.sap.dbtech.jdbcext.XAResourceHandler;
import com.sap.dbtech.jdbcext.XAResourceHandlerImpl;
import com.sap.dbtech.jdbcext.XAResourceHandlerSimpleImpl;
import com.sap.dbtech.jdbcext.XATrace;
import com.sap.dbtech.jdbcext.XATransaction;
import com.sap.dbtech.jdbcext.wrapper.Connection;
import java.lang.ref.WeakReference;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAConnectionSapDB
extends ConnectionListenerBag
implements XAResource,
XAConnection {
    Properties connectProperties;
    XADataSourceSapDB ds;
    XATrace trace;
    WeakReference lastClientConnection;
    private java.sql.Connection nonTxConnection;
    XATransaction currentTransaction;
    int transactionTimeout;
    XAResourceHandler xaResourceHandler;
    boolean isClosed = false;

    XAConnectionSapDB(Properties connectProperties, XADataSourceSapDB ds, XATrace trace) throws SQLException {
        this.connectProperties = connectProperties;
        this.trace = trace;
        this.ds = ds;
        this.transactionTimeout = ds.getXATimeout();
        this.currentTransaction = null;
        this.nonTxConnection = ds.openPhysicalConnection(connectProperties);
        DatabaseMetaData dbmd = this.nonTxConnection.getMetaData();
        this.xaResourceHandler = dbmd.getDatabaseMajorVersion() >= 7 && dbmd.getDatabaseMinorVersion() >= 8 ? new XAResourceHandlerImpl(this) : new XAResourceHandlerSimpleImpl(this);
    }

    boolean isTraceEnabled() {
        return this.trace.m_trcCtl.isTraceOn();
    }

    void traceXAError(Xid xid, int code, Exception e) {
        if (this.trace.m_trcCtl.isTraceOn()) {
            this.trace.traceXAError(xid, code, e);
        }
    }

    void trace(Xid xid, String message) {
        if (this.trace.m_trcCtl.isTraceOn()) {
            this.trace.trace(xid, message);
        }
    }

    void trace(String message) {
        if (this.trace.m_trcCtl.isTraceOn()) {
            this.trace.trace(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            try {
                this.closeLastOpenClient();
                if (this.nonTxConnection != null) {
                    this.nonTxConnection.close();
                }
            }
            finally {
                if (!this.isClosed) {
                    if (this.ds != null) {
                        this.ds.releaseXAConnection(this);
                    }
                    this.isClosed = true;
                }
            }
        }
    }

    public java.sql.Connection getConnection() throws SQLException {
        this.closeLastOpenClient();
        XAClientConnectionSapDB cc = new XAClientConnectionSapDB();
        this.lastClientConnection = new WeakReference<XAClientConnectionSapDB>(cc);
        return cc;
    }

    public XAResource getXAResource() throws SQLException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            if (this.isTraceEnabled()) {
                this.trace(xid, "start");
            }
            if (xid == null) {
                this.xaerror(xid, -5);
            }
            if (this.currentTransaction != null) {
                this.xaerror(xid, -9);
            }
            switch (flags) {
                case 0: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: TMNOFLAGS");
                    }
                    XADataSourceSapDB xADataSourceSapDB = this.ds;
                    synchronized (xADataSourceSapDB) {
                        if (this.ds.getXATransaction(xid) != null) {
                            this.xaerror(xid, -8);
                        }
                        try {
                            java.sql.Connection c;
                            if (this.nonTxConnection != null) {
                                this.nonTxConnection.setAutoCommit(false);
                                c = this.nonTxConnection;
                                if (!this.xaResourceHandler.isConnectionValidAfterGlobalTransEnd()) {
                                    this.nonTxConnection = null;
                                }
                            } else {
                                c = this.ds.openPhysicalConnection(this.connectProperties);
                            }
                            long timeout = System.currentTimeMillis() + (long)(1000 * this.transactionTimeout);
                            this.currentTransaction = new XATransaction(xid, c, timeout, this.xaResourceHandler);
                            this.ds.addXATransaction(this.currentTransaction);
                            this.xaResourceHandler.start(xid, this.currentTransaction);
                        }
                        catch (SQLException sqlEx) {
                            this.xaerror(xid, -3, sqlEx);
                        }
                        break;
                    }
                }
                case 0x200000: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: TMJOIN");
                    }
                    XADataSourceSapDB xADataSourceSapDB = this.ds;
                    synchronized (xADataSourceSapDB) {
                        XATransaction tx = this.ds.getXATransaction(xid);
                        this.xaResourceHandler.join(xid, tx);
                        break;
                    }
                }
                case 0x8000000: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: TMRESUME");
                    }
                    XADataSourceSapDB xADataSourceSapDB = this.ds;
                    synchronized (xADataSourceSapDB) {
                        XATransaction tx = this.ds.getXATransaction(xid);
                        if (tx == null) {
                            this.xaerror(xid, -5);
                        }
                        this.currentTransaction = tx;
                        this.xaResourceHandler.resume(xid, tx);
                        break;
                    }
                }
                default: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: unknown flags");
                    }
                    this.xaerror(xid, -5);
                }
            }
            this.currentTransaction.setStatus(0);
            this.setTransactional(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "end");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        switch (flags) {
            case 0x4000000: {
                if (!this.isTraceEnabled()) break;
                this.trace(xid, "end: TMSUCCESS");
                break;
            }
            case 0x20000000: {
                if (!this.isTraceEnabled()) break;
                this.trace(xid, "end: TMFAIL");
                break;
            }
            case 0x2000000: {
                if (!this.isTraceEnabled()) break;
                this.trace(xid, "end: TMSUSPEND");
                break;
            }
            default: {
                this.xaerror(xid, -5);
            }
        }
        try {
            XADataSourceSapDB xADataSourceSapDB = this.ds;
            synchronized (xADataSourceSapDB) {
                XATransaction tx = this.ds.getXATransaction(xid);
                if (tx == null) {
                    this.xaerror(xid, -4);
                }
                if (this.currentTransaction != null && !this.currentTransaction.xid.equals(xid)) {
                    this.xaerror(xid, -4);
                }
                if (tx.getStatus() == 2) {
                    this.xaerror(xid, 106);
                }
                this.xaResourceHandler.end(xid, flags, tx);
            }
        }
        finally {
            this.currentTransaction = null;
            this.setTransactional(false);
            this.silentCloseLastOpenClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "commit");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction tx = this.ds.getXATransaction(xid);
            if (tx == null) {
                this.xaerror(xid, -4);
            }
            if (tx.getStatus() == 2) {
                this.xaerror(xid, 6);
            }
            if (this.currentTransaction == tx) {
                this.currentTransaction = null;
                this.setTransactional(false);
                this.silentCloseLastOpenClient();
            }
            if (onePhase || tx.getStatus() == 3) {
                try {
                    this.xaResourceHandler.commit(xid, onePhase, tx);
                }
                finally {
                    if (tx.getStatus() == 1) {
                        this.ds.removeXATransaction(xid);
                    }
                }
            } else {
                this.xaerror(xid, -6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "rollback");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction tx = this.ds.getXATransaction(xid);
            if (tx == null) {
                this.xaerror(xid, -4);
            }
            if (tx.getStatus() == 2) {
                this.ds.removeXATransaction(xid);
            }
            if (tx.getStatus() == 1) {
                this.ds.removeXATransaction(xid);
                this.xaerror(xid, -3);
            }
            this.xaResourceHandler.rollback(xid, tx);
            if (this.currentTransaction == tx) {
                this.setTransactional(false);
            }
            this.ds.removeXATransaction(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "forget");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction tx = this.ds.getXATransaction(xid);
            if (tx != null) {
                if (this.currentTransaction == tx) {
                    this.currentTransaction = null;
                    this.silentCloseLastOpenClient();
                    this.setTransactional(false);
                }
                this.ds.removeXATransaction(xid);
                this.xaResourceHandler.forget(xid, tx);
            }
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource rm) throws XAException {
        boolean result = false;
        if (rm != null && rm instanceof XAConnectionSapDB) {
            XAConnectionSapDB c = (XAConnectionSapDB)rm;
            result = c.ds == this.ds;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        int rc;
        if (this.isTraceEnabled()) {
            this.trace(xid, "prepare");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            if (this.currentTransaction != null && this.currentTransaction.xid.equals(xid)) {
                this.silentCloseLastOpenClient();
                this.currentTransaction = null;
                this.setTransactional(false);
            }
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction tx = this.ds.getXATransaction(xid);
            if (tx == null) {
                this.xaerror(xid, -4);
            }
            if (tx.getStatus() == 2) {
                this.xaerror(xid, 100);
            }
            if ((rc = this.xaResourceHandler.prepare(xid, tx)) == 0) {
                tx.setStatus(3);
            }
        }
        return rc;
    }

    public Xid[] recover(int flags) throws XAException {
        return this.xaResourceHandler.recover(flags);
    }

    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        if (transactionTimeout < 0) {
            this.xaerror(null, -5);
        }
        this.transactionTimeout = transactionTimeout;
        return true;
    }

    void sendErrorEvent(SQLException sqlEx) {
        super.sendErrorEvent(this, sqlEx);
    }

    void sendCloseEvent() {
        super.sendCloseEvent(this);
    }

    public void setTransactional(boolean b) {
        Object o;
        Object v0 = o = this.lastClientConnection == null ? null : this.lastClientConnection.get();
        if (o == null) {
            return;
        }
        ((XAClientConnectionSapDB)o).setTransactional(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    java.sql.Connection getRealConnection(Object client) throws SQLException {
        Object o;
        Object v0 = o = this.lastClientConnection == null ? null : this.lastClientConnection.get();
        if (o != client) {
            return null;
        }
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            if (this.currentTransaction != null) {
                ((XAClientConnectionSapDB)client).setTransactional(true);
                if (this.currentTransaction.physicalConnection != null) {
                    this.currentTransaction.physicalConnection.setAutoCommit(false);
                }
                return this.currentTransaction.physicalConnection;
            }
            if (this.nonTxConnection == null) {
                this.nonTxConnection = this.ds.openPhysicalConnection(this.connectProperties);
            }
            ((XAClientConnectionSapDB)client).setTransactional(false);
            return this.nonTxConnection;
        }
    }

    java.sql.Connection reconnectNonTxConnection() throws SQLException {
        this.nonTxConnection = null;
        return this.getNonTxConnectionAndOpenOnDemand();
    }

    java.sql.Connection getNonTxConnectionAndOpenOnDemand() throws SQLException {
        if (this.nonTxConnection == null) {
            this.nonTxConnection = this.ds.openPhysicalConnection(this.connectProperties);
        }
        return this.nonTxConnection;
    }

    java.sql.Connection getNonTxConnection() throws SQLException {
        return this.nonTxConnection;
    }

    XAConnectionSapDB self() {
        return this;
    }

    void silentCloseLastOpenClient() {
        if (!this.xaResourceHandler.isConnectionValidAfterGlobalTransEnd()) {
            try {
                this.closeLastOpenClient();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLastOpenClient() throws SQLException {
        Object o;
        Object v0 = o = this.lastClientConnection == null ? null : this.lastClientConnection.get();
        if (o != null) {
            XAConnectionSapDB xAConnectionSapDB = this;
            synchronized (xAConnectionSapDB) {
                XAClientConnectionSapDB client = o;
                client.closeWithoutEvent();
            }
        }
    }

    public void xaerror(Xid xid, int code) throws XAException {
        if (this.isTraceEnabled()) {
            this.traceXAError(xid, code, null);
        }
        throw new XAException(code);
    }

    public void xaerror(Xid xid, int code, Exception e) throws XAException {
        if (this.isTraceEnabled()) {
            this.traceXAError(xid, code, e);
        }
        XAException xaEx = new XAException(code);
        xaEx.initCause(e);
        throw xaEx;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    class XAClientConnectionSapDB
    extends Connection {
        boolean closed = false;
        boolean transactional = false;

        XAClientConnectionSapDB() {
        }

        public java.sql.Connection getPhysicalConnection() throws SQLException {
            java.sql.Connection result = XAConnectionSapDB.this.getRealConnection(this);
            if (result == null) {
                throw SQLExceptionSapDB.generateSQLException("error.objectisclosed", this);
            }
            return result;
        }

        public void setTransactional(boolean b) {
            this.transactional = b;
        }

        public void exceptionOccurred(SQLException sqlEx) {
            if (sqlEx instanceof SQLExceptionSapDBInterface) {
                SQLExceptionSapDBInterface sapEx = (SQLExceptionSapDBInterface)((Object)sqlEx);
                if (sapEx.isConnectionReleasing()) {
                    XAConnectionSapDB.this.sendErrorEvent(sqlEx);
                }
            } else {
                XAConnectionSapDB.this.sendErrorEvent(sqlEx);
            }
        }

        public boolean isClosed() throws SQLException {
            return this.closed || XAConnectionSapDB.this.getRealConnection(this) == null || super.isClosed();
        }

        public void setAutoCommit(boolean autocommit) throws SQLException {
            if (this.transactional) {
                throw SQLExceptionSapDB.generateSQLException("error.autocommit.xasession");
            }
            super.setAutoCommit(autocommit);
        }

        public void rollback() throws SQLException {
            if (this.transactional) {
                throw SQLExceptionSapDB.generateSQLException("error.rollback.xasession");
            }
            super.rollback();
        }

        public void commit() throws SQLException {
            if (this.transactional) {
                throw SQLExceptionSapDB.generateSQLException("error.commit.xasession");
            }
            super.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeWithoutEvent() throws SQLException {
            if (!this.closed) {
                XAConnectionSapDB xAConnectionSapDB = XAConnectionSapDB.this.self();
                synchronized (xAConnectionSapDB) {
                    block9: {
                        try {
                            if (this.transactional) {
                                this.closed = true;
                            } else {
                                if (!this.getAutoCommit()) {
                                    this.rollback();
                                }
                                this.closed = true;
                            }
                        }
                        catch (SQLException oic) {
                            if (oic.getErrorCode() == -11212) break block9;
                            throw oic;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            if (!this.closed) {
                XAConnectionSapDB xAConnectionSapDB = XAConnectionSapDB.this.self();
                synchronized (xAConnectionSapDB) {
                    block9: {
                        try {
                            if (this.transactional) {
                                this.closed = true;
                                XAConnectionSapDB.this.sendCloseEvent();
                            } else {
                                if (!this.getAutoCommit()) {
                                    this.rollback();
                                }
                                this.closed = true;
                                XAConnectionSapDB.this.sendCloseEvent();
                            }
                        }
                        catch (SQLException oic) {
                            if (oic.getErrorCode() != -11212) break block9;
                            XAConnectionSapDB.this.sendCloseEvent();
                        }
                    }
                }
            }
        }

        public void finalize() {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

