/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.DataTruncation;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.VDNNumber;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class DBTechTranslator {
    protected int logicalLength;
    protected int physicalLength;
    protected int bufpos_input;
    protected int bufpos_output;
    protected byte mode;
    protected byte ioType;
    protected byte dataType;
    protected boolean writeAllowed = false;
    protected boolean isReadOnly = false;
    protected boolean isAutoIncrement = false;
    protected String characterDatatypePostfix = "";
    private ColumnInfo colInfo;
    private int colIndex;
    public static final int nullDefineByte = 1;
    public static final int specialNullValueDefineByte = 2;
    public static final int unknownDefineByte = -1;
    public static final String DefaultValue = "DefaultValue";

    protected DBTechTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncre) {
        this.mode = (byte)mode;
        this.ioType = (byte)ioType;
        this.dataType = (byte)dataType;
        this.logicalLength = len;
        this.physicalLength = ioLen;
        this.bufpos_input = bufpos_in;
        this.bufpos_output = bufpos_out;
    }

    public void allowWrites() {
        this.writeAllowed = true;
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("AsciiStream");
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("BigDecimal");
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("BigDecimal");
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("BinaryStream");
    }

    public Blob getBlob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("Blob");
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("boolean");
    }

    public int getOutputBufpos() {
        return this.bufpos_output;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("byte");
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("byte []");
    }

    public String getCatalogName() {
        return "";
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("CharacterStream");
    }

    public Clob getClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw this.newGetException("Clob");
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public String getColumnClassName() {
        String result;
        switch (this.dataType) {
            case 0: {
                result = "java.math.BigDecimal";
                break;
            }
            case 1: {
                result = "java.math.BigDecimal";
                break;
            }
            case 2: 
            case 3: {
                result = "java.lang.String";
                break;
            }
            case 4: {
                result = "byte[]";
                break;
            }
            case 5: {
                result = "byte[]";
                break;
            }
            case 10: {
                result = "java.sql.Date";
                break;
            }
            case 11: {
                result = "java.sql.Time";
                break;
            }
            case 12: {
                result = "java.math.BigDecimal";
                break;
            }
            case 13: {
                result = "java.sql.Timestamp";
                break;
            }
            case 14: {
                result = "java.lang.Object";
                break;
            }
            case 15: {
                result = "java.math.BigDecimal";
                break;
            }
            case 16: {
                result = "java.math.BigDecimal";
                break;
            }
            case 17: {
                result = "java.lang.Long";
                break;
            }
            case 18: {
                result = "java.io.InputStream";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                result = "java.io.InputStream";
                break;
            }
            case 8: 
            case 21: {
                result = "java.io.InputStream";
                break;
            }
            case 22: {
                result = "java.io.Reader";
                break;
            }
            case 23: {
                result = "java.lang.Boolean";
                break;
            }
            case 24: {
                result = "java.lang.String";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                result = "java.lang.Object";
                break;
            }
            case 29: {
                result = "java.lang.Integer";
                break;
            }
            case 30: {
                result = "java.lang.Integer";
                break;
            }
            case 31: 
            case 32: {
                result = "java.lang.String";
                break;
            }
            case 33: {
                result = "byte[]";
                break;
            }
            case 34: {
                result = "java.io.Reader";
                break;
            }
            case 35: {
                result = "java.io.Reader";
                break;
            }
            case 36: {
                result = "java.lang.String";
                break;
            }
            default: {
                result = "java.lang.Object";
            }
        }
        return result;
    }

    public int getColumnDisplaySize() {
        return this.logicalLength;
    }

    public String getColumnLabel() {
        return this.colInfo.columnDisplayName;
    }

    public String getColumnName() {
        return this.colInfo.columnName;
    }

    public int getColumnType() {
        int result;
        switch (this.dataType) {
            case 0: {
                result = 3;
                break;
            }
            case 1: {
                result = 6;
                break;
            }
            case 2: 
            case 3: {
                result = 1;
                break;
            }
            case 4: {
                result = -2;
                break;
            }
            case 5: {
                result = -2;
                break;
            }
            case 10: {
                result = 91;
                break;
            }
            case 11: {
                result = 92;
                break;
            }
            case 12: {
                result = 6;
                break;
            }
            case 13: {
                result = 93;
                break;
            }
            case 14: {
                result = 1111;
                break;
            }
            case 15: {
                result = 2;
                break;
            }
            case 16: {
                result = 1111;
                break;
            }
            case 17: {
                result = 1111;
                break;
            }
            case 18: {
                result = 1;
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                result = -1;
                break;
            }
            case 8: 
            case 21: {
                result = -4;
                break;
            }
            case 22: {
                result = -1;
                break;
            }
            case 23: {
                result = -7;
                break;
            }
            case 24: {
                result = 1;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                result = 1111;
                break;
            }
            case 29: {
                result = 5;
                break;
            }
            case 30: {
                result = 4;
                break;
            }
            case 31: 
            case 32: {
                result = 12;
                break;
            }
            case 33: {
                result = -3;
                break;
            }
            case 34: {
                result = -1;
                break;
            }
            case 35: {
                result = -1;
                break;
            }
            case 36: {
                result = 12;
                break;
            }
            default: {
                result = 1111;
            }
        }
        return result;
    }

    public String getColumnTypeName() {
        String result;
        switch (this.dataType) {
            case 2: 
            case 3: 
            case 18: {
                result = "CHAR ASCII";
                break;
            }
            case 4: 
            case 5: {
                result = "CHAR BYTE";
                break;
            }
            case 24: {
                result = "CHAR UNICODE";
                break;
            }
            case 31: 
            case 32: {
                result = "VARCHAR ASCII";
                break;
            }
            case 33: {
                result = "VARCHAR BYTE";
                break;
            }
            case 36: {
                result = "VARCHAR UNICODE";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 22: {
                result = "LONG ASCII";
                break;
            }
            case 8: 
            case 21: {
                result = "LONG BYTE";
                break;
            }
            case 34: 
            case 35: {
                result = "LONG UNICODE";
                break;
            }
            case 10: {
                result = "DATE";
                break;
            }
            case 11: {
                result = "TIME";
                break;
            }
            case 13: {
                result = "TIMESTAMP";
                break;
            }
            case 23: {
                result = "BOOLEAN";
                break;
            }
            case 0: 
            case 15: {
                result = "FIXED";
                break;
            }
            case 1: 
            case 12: {
                result = "FLOAT";
                break;
            }
            case 29: {
                result = "SMALLINT";
                break;
            }
            case 30: {
                result = "INTEGER";
                break;
            }
            default: {
                result = MessageTranslator.translate("unknowntype");
            }
        }
        return result;
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        throw this.newGetException("Date");
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("double");
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("float");
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("int");
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("long");
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("Object");
    }

    public int getPhysicalLength() {
        return this.physicalLength;
    }

    public int getPrecision() {
        return this.logicalLength;
    }

    public Putval getPutvalObject() {
        return null;
    }

    public int getScale() {
        return 0;
    }

    public String getSchemaName() {
        return this.colInfo.schemaName;
    }

    public short getShort(SQLParamController controllerc, DataPart mem) throws SQLException {
        throw this.newGetException("short");
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        Object rawResult = this.getObject(controller, mem);
        String result = rawResult == null ? null : rawResult.toString();
        return result;
    }

    public String getTableName() {
        return this.colInfo.tableName;
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        throw this.newGetException("Time");
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        throw this.newGetException("Timestamp");
    }

    public InputStream getUnicodeStream(SQLParamController controller, DataPart mem) throws SQLException {
        throw this.newGetException("UnicodeStream");
    }

    public int getParameterMode() {
        switch (this.ioType) {
            case 1: {
                return 4;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isDefinitelyWritable() {
        return false;
    }

    public boolean isInput() {
        return this.ioType != 1;
    }

    public boolean isOutput() {
        return this.ioType != 0;
    }

    public boolean isLongKind() {
        boolean result = false;
        switch (this.dataType) {
            case 6: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 34: 
            case 35: {
                result = true;
            }
        }
        return result;
    }

    public boolean isNull(SQLParamController controller, DataPart mem) throws SQLException {
        return mem.isNull(controller, this.bufpos_output);
    }

    public int checkDefineByte(SQLParamController controller, DataPart mem) {
        return mem.checkDefineByte(controller, mem, this.bufpos_output);
    }

    public int isNullable() {
        int result = (this.mode & 1) != 0 ? 0 : ((this.mode & 2) != 0 ? 1 : 2);
        return result;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isSearchable() {
        return true;
    }

    public boolean isSigned() {
        boolean result = false;
        switch (this.dataType) {
            case 0: 
            case 1: 
            case 5: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 29: 
            case 30: {
                result = true;
            }
        }
        return result;
    }

    public boolean isWritable() {
        return this.writeAllowed;
    }

    public void put(DataPart dataPart, Object data) throws SQLException {
        if (this.ioType != 1) {
            if (data == null) {
                dataPart.putNull(this.bufpos_input, this.physicalLength - 1);
            } else if (data == DefaultValue) {
                dataPart.putDefault(this.bufpos_input, this.physicalLength - 1);
            } else {
                this.putSpecific(dataPart, data);
                dataPart.addArg(this.bufpos_input, this.physicalLength - 1);
            }
        }
    }

    public void putProcOutput(DataPart dataPart, Object data) throws SQLException {
        if (this.ioType != 0) {
            if (data == null) {
                dataPart.putNull(this.bufpos_input, this.physicalLength - 1);
            } else if (data == DefaultValue) {
                dataPart.putDefault(this.bufpos_input, this.physicalLength - 1);
            } else {
                this.putSpecific(dataPart, data);
                dataPart.addArg(this.bufpos_input, this.physicalLength - 1);
            }
        }
    }

    protected abstract void putSpecific(DataPart var1, Object var2) throws SQLException;

    public void setColIndex(int index) {
        this.colIndex = index;
    }

    public void setColName(ColumnInfo name) {
        this.colInfo = name;
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        return this.transObjectForInput(stream);
    }

    public Object transBigDecimalForInput(BigDecimal bigDecimal) throws SQLException {
        return this.transObjectForInput(bigDecimal);
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        return this.transObjectForInput(stream);
    }

    public Object transBlobForInput(Blob blob, ConnectionSapDB conn) throws SQLException {
        return this.transObjectForInput(blob);
    }

    public Object transBooleanForInput(boolean val) throws SQLException {
        if (val) {
            return this.transIntForInput(1);
        }
        return this.transIntForInput(0);
    }

    public Object transByteForInput(byte val) throws SQLException {
        return this.transObjectForInput(BigDecimal.valueOf(val));
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        throw this.newGetException("Bytes");
    }

    public Object transCharacterStreamForInput(Reader stream, long length) throws SQLException {
        return this.transObjectForInput(stream);
    }

    public Object transClobForInput(Clob clob, ConnectionSapDB conn) throws SQLException {
        return this.transObjectForInput(clob);
    }

    public Object transDateForInput(Date val, Calendar cal) throws SQLException {
        return this.transObjectForInput(val);
    }

    public Object transDoubleForInput(double val) throws SQLException {
        try {
            return this.transObjectForInput(new BigDecimal(val));
        }
        catch (NumberFormatException numberFormatEx) {
            if (Double.isInfinite(val) || Double.isNaN(val)) {
                throw SQLExceptionSapDB.generateSQLException("error.special.number.unsupported", Double.toString(val));
            }
            throw numberFormatEx;
        }
    }

    public Object transFloatForInput(float val) throws SQLException {
        return this.transObjectForInput(new BigDecimal(val));
    }

    public Object transIntForInput(int val) throws SQLException {
        return this.transObjectForInput(BigDecimal.valueOf(val));
    }

    public Object transLongForInput(long val) throws SQLException {
        return this.transObjectForInput(BigDecimal.valueOf(val));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object transObjectForInput(Object val) throws SQLException {
        if (val == null) {
            return null;
        }
        Object result = this.transSpecificForInput(val);
        if (result != null) {
            return result;
        }
        if (val instanceof String) {
            result = this.transStringForInput((String)val);
        }
        if (val instanceof BigDecimal) {
            return this.transStringForInput(VDNNumber.bigDecimal2PlainString((BigDecimal)val));
        }
        Class<?> clazz = val.getClass();
        if (!clazz.isArray()) return this.transStringForInput(val.toString());
        String clazzName = clazz.getName();
        if (clazzName.equals("[B")) {
            return this.transBytesForInput((byte[])val);
        }
        if (!clazzName.equals("[C")) throw this.newSetException(clazzName);
        return this.transStringForInput(new String((char[])val));
    }

    public Object transShortForInput(short val) throws SQLException {
        return this.transObjectForInput(BigDecimal.valueOf(val));
    }

    protected abstract Object transSpecificForInput(Object var1) throws SQLException;

    public Object transStringForInput(String val) throws SQLException {
        throw this.newSetException("String");
    }

    public Object transTimeForInput(Time val, Calendar cal) throws SQLException {
        return this.transObjectForInput(val);
    }

    public Object transTimestampForInput(Timestamp val, Calendar cal) throws SQLException {
        return this.transObjectForInput(val);
    }

    public Object transUnicodeStreamForInput(InputStream stream) throws SQLException {
        return this.transObjectForInput(stream);
    }

    public Object cloneObjectForBatch(Object object) {
        return object;
    }

    protected SQLException newGetException(String requestedType) {
        return SQLExceptionSapDB.generateSQLException("error.conversion.sqljava", this.getColumnTypeName(), requestedType);
    }

    protected SQLException newSetException(String requestedType) {
        return SQLExceptionSapDB.generateSQLException("error.conversion.javasql", requestedType, this.getColumnTypeName());
    }

    protected SQLException newParseException(String data, String requestedType) {
        if (requestedType == null) {
            requestedType = this.getColumnTypeName();
        }
        return SQLExceptionSapDB.generateSQLException("error.conversion.data", data, requestedType);
    }

    public byte bigDecimal2Byte(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0;
        }
        return (byte)bd.intValue();
    }

    public double bigDecimal2Double(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0.0;
        }
        return bd.doubleValue();
    }

    public float bigDecimal2Float(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0.0f;
        }
        return (float)bd.doubleValue();
    }

    public int bigDecimal2Int(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0;
        }
        return bd.intValue();
    }

    public long bigDecimal2Long(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0L;
        }
        return bd.longValue();
    }

    public short bigDecimal2Short(BigDecimal bd) throws SQLException {
        if (bd == null) {
            return 0;
        }
        return (short)bd.intValue();
    }

    protected void checkFieldLimits(int byteLength) throws SQLException {
        if (byteLength > this.physicalLength - 1) {
            throw DataTruncation.createDataTruncationException(this.getColIndex() + 1, true, false, byteLength, this.physicalLength - 1);
        }
    }

    protected boolean isUnicodeColumn() {
        switch (this.dataType) {
            case 34: 
            case 35: {
                return true;
            }
        }
        return false;
    }

    public boolean isStreamKind() {
        return false;
    }

    public void setProcParamInfo(DBProcParameterInfo info) throws SQLException {
    }

    static class CalendarUtil {
        CalendarUtil() {
        }

        static Timestamp getTimestampFromCalendar(Calendar cal, int nano) {
            Timestamp ts = new Timestamp(cal.getTime().getTime());
            ts.setNanos(nano);
            return ts;
        }

        static Time getTimeFromCalendar(Calendar cal) {
            return new Time(cal.getTime().getTime());
        }

        static Date getDateFromCalendar(Calendar cal) {
            return new Date(cal.getTime().getTime());
        }
    }
}

